/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor.service;

import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.memoizers.BiFunctionMemoizer;
import com.avioconsulting.mule.opentelemetry.internal.util.memoizers.FunctionMemoizer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;

class ComponentLocatorService {
    private final Map<String, ComponentLocation> componentLocationMap;
    private final FunctionMemoizer<String, Component> findComponentByLocation;
    private final BiFunctionMemoizer<String, ComponentLocation, Component> findComponentByComponentLocation;
    private final FunctionMemoizer<String, Long> countSiblingsByLocation;
    private final ConfigurationComponentLocator configurationComponentLocator;

    ComponentLocatorService(ConfigurationComponentLocator configurationComponentLocator) {
        this.configurationComponentLocator = configurationComponentLocator;
        HashMap map = new HashMap();
        configurationComponentLocator.findAllLocations().forEach(l -> map.put(l.getLocation(), l));
        this.componentLocationMap = Collections.unmodifiableMap(map);
        this.findComponentByLocation = FunctionMemoizer.memoize(location -> {
            Location l = Location.builderFromStringRepresentation((String)location).build();
            return configurationComponentLocator.find(l).orElse(null);
        });
        this.findComponentByComponentLocation = BiFunctionMemoizer.memoize((key, location) -> {
            Location l = Location.builderFromStringRepresentation((String)location.getLocation()).build();
            return configurationComponentLocator.find(l).orElseGet(() -> this.configurationComponentLocator.find(location.getComponentIdentifier().getIdentifier()).stream().filter(c -> c.getLocation().getLocation().equalsIgnoreCase(location.getLocation())).findFirst().orElse(null));
        });
        this.countSiblingsByLocation = FunctionMemoizer.memoize(location -> this.componentLocationMap.keySet().stream().filter(l -> l.equalsIgnoreCase(ComponentsUtil.getLocationParent(location) + "/")).count());
    }

    public Map<String, ComponentLocation> getAllComponentLocations() {
        return this.componentLocationMap;
    }

    public ComponentLocation findComponentLocation(String location) {
        return this.componentLocationMap.get(location);
    }

    public long findSiblingCount(String location) {
        return this.countSiblingsByLocation.apply(location);
    }

    public Component findComponentByLocation(String location) {
        return this.findComponentByLocation.apply(location);
    }

    public Component findComponentByLocation(ComponentLocation location) {
        return this.findComponentByComponentLocation.apply(location.getLocation(), location);
    }
}

