/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionStore;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.api.traces.TransactionContext;
import com.avioconsulting.mule.opentelemetry.internal.store.BatchTransaction;
import com.avioconsulting.mule.opentelemetry.internal.store.FlowSpan;
import com.avioconsulting.mule.opentelemetry.internal.store.FlowTransaction;
import com.avioconsulting.mule.opentelemetry.internal.store.ProcessorSpan;
import com.avioconsulting.mule.opentelemetry.internal.store.Transaction;
import com.avioconsulting.mule.opentelemetry.internal.store.TransactionProcessor;
import com.avioconsulting.mule.opentelemetry.internal.util.BatchHelperUtil;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTransactionStore
implements TransactionStore {
    private static TransactionStore service;
    private final ConcurrentHashMap<String, Transaction> transactionMap = new ConcurrentHashMap();
    private static final Logger LOGGER;
    private final TransactionProcessor transactionProcessor;

    private InMemoryTransactionStore(TransactionProcessor transactionProcessor) {
        this.transactionProcessor = transactionProcessor;
    }

    public static synchronized TransactionStore getInstance(TransactionProcessor transactionProcessor) {
        if (service == null) {
            service = new InMemoryTransactionStore(transactionProcessor);
        }
        return service;
    }

    public static void _resetForTesting() {
        service = null;
    }

    @Override
    public void startTransaction(TraceComponent traceComponent, String rootName, SpanBuilder spanBuilder) {
        String transactionId = traceComponent.getTransactionId();
        Transaction transaction = this.getTransaction(traceComponent.getTransactionId());
        if (transaction != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Start transaction {} for flow '{}' - Adding to existing transaction", (Object)transactionId, (Object)rootName);
            }
            transaction.addChildTransaction(traceComponent, spanBuilder);
        } else {
            boolean isBatchJob = traceComponent.hasTagFor(SemanticAttributes.MULE_BATCH_JOB_NAME.getKey());
            if (isBatchJob) {
                this.startBatchTransaction(traceComponent, rootName, spanBuilder, transactionId);
            } else {
                this.startFlowTransaction(traceComponent, rootName, spanBuilder, transactionId);
            }
        }
    }

    private void startFlowTransaction(TraceComponent traceComponent, String rootName, SpanBuilder spanBuilder, String transactionId) {
        Span span = spanBuilder.startSpan();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Start Flow transaction {} for flow '{}': OT SpanId {}, TraceId {}", new Object[]{transactionId, rootName, span.getSpanContext().getSpanId(), span.getSpanContext().getTraceId()});
        }
        this.transactionMap.put(transactionId, new FlowTransaction(traceComponent.getTransactionId(), span.getSpanContext().getTraceId(), rootName, new FlowSpan(rootName, span, traceComponent), traceComponent.getStartTime()));
    }

    private void startBatchTransaction(TraceComponent traceComponent, String rootName, SpanBuilder spanBuilder, String transactionId) {
        Span span = spanBuilder.startSpan();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Start Batch transaction {} for flow '{}': OT SpanId {}, TraceId {}", new Object[]{transactionId, rootName, span.getSpanContext().getSpanId(), span.getSpanContext().getTraceId()});
        }
        this.transactionMap.put(transactionId, new BatchTransaction(traceComponent.getTransactionId(), span.getSpanContext().getTraceId(), rootName, span, traceComponent, this.transactionProcessor::spanBuilder, this.transactionProcessor.getComponentRegistryService()));
    }

    @Override
    public void addTransactionTags(String transactionId, String tagPrefix, Map<String, String> tags) {
        AttributesBuilder builder = Attributes.builder();
        String format = "%s.%s";
        tags.forEach((k, v) -> builder.put(String.format(format, tagPrefix, k), v));
        Transaction transaction = this.getTransaction(transactionId);
        Span span = transaction.getTransactionSpan();
        if (span != null) {
            span.setAllAttributes(builder.build());
        }
    }

    private Transaction getTransaction(String transactionId) {
        return this.transactionMap.get(transactionId);
    }

    @Override
    public TransactionContext getTransactionContext(String transactionId, String componentLocation) {
        Transaction transaction = this.getTransaction(transactionId);
        if (componentLocation == null) {
            return transaction.getTransactionContext();
        }
        ProcessorSpan processorSpan = null;
        if (transaction != null && (processorSpan = transaction.findSpan(componentLocation)) != null) {
            return TransactionContext.of(processorSpan.getSpan(), transaction);
        }
        return transaction.getTransactionContext();
    }

    public String getTraceIdForTransaction(String transactionId) {
        return this.transactionMap.containsKey(transactionId) ? this.getTransaction(transactionId).getTraceId() : null;
    }

    @Override
    public TransactionMeta endTransaction(TraceComponent traceComponent, Consumer<Span> spanUpdater) {
        Transaction transaction;
        Consumer<Span> endSpan = span -> {
            if (spanUpdater != null) {
                spanUpdater.accept((Span)span);
            }
            span.end(traceComponent.getEndTime());
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Ended transaction {} for flow '{}': OT SpanId {}, TraceId {}", new Object[]{traceComponent, traceComponent.getName(), span.getSpanContext().getSpanId(), span.getSpanContext().getTraceId()});
            }
        };
        TransactionMeta transactionMeta = transaction = this.getTransaction(traceComponent.getTransactionId());
        if (transaction != null) {
            if (transaction.getRootFlowName().equals(traceComponent.getName())) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Marking the end time of transaction {} from map for {} - Context Id {}", new Object[]{traceComponent.getTransactionId(), traceComponent.getName(), traceComponent.getEventContextId()});
                }
                transaction.endRootSpan(traceComponent, endSpan);
            } else {
                transactionMeta = transaction.endChildTransaction(traceComponent, endSpan);
            }
            if (transaction.hasEnded()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Removed transaction {} from map for {} - Context Id {}", new Object[]{traceComponent.getTransactionId(), traceComponent.getName(), traceComponent.getEventContextId()});
                }
                this.transactionMap.remove(transaction.getTransactionId());
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("No transaction found for transaction {}", (Object)traceComponent.getTransactionId());
        }
        if (transactionMeta == null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("No transaction meta found for {} ", (Object)traceComponent);
            }
        } else if (transactionMeta.getTags() != null) {
            traceComponent.copyTagsTo(transactionMeta.getTags());
        }
        return transactionMeta;
    }

    @Override
    public SpanMeta addProcessorSpan(String containerName, TraceComponent traceComponent, SpanBuilder spanBuilder) {
        Transaction transaction = this.getTransaction(traceComponent.getTransactionId());
        if (transaction == null && BatchHelperUtil.hasBatchJobInstanceId(traceComponent)) {
            String batchJobInstanceId = BatchHelperUtil.getBatchJobInstanceId(traceComponent);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Looking for transaction for batch job instance id {} ", (Object)batchJobInstanceId);
            }
            transaction = this.getTransaction(batchJobInstanceId);
        }
        if (transaction == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("No transaction found for transaction {}. Map contains transactions for {}", (Object)traceComponent.getTransactionId(), (Object)this.transactionMap.keySet());
            }
            return null;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Adding Processor span to transaction {} for location '{}'", (Object)traceComponent.getTransactionId(), (Object)traceComponent.getLocation());
        }
        SpanMeta span = transaction.addProcessorSpan(containerName, traceComponent, spanBuilder);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Adding Processor span to transaction {} for locator span '{}': OT SpanId {}, TraceId {}", new Object[]{traceComponent.getTransactionId(), traceComponent.getLocation(), span.getSpanId(), span.getTraceId()});
        }
        return span;
    }

    @Override
    public SpanMeta endProcessorSpan(String transactionId, TraceComponent traceComponent, Consumer<Span> spanUpdater, Instant endTime) {
        Transaction transaction;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Ending Processor span of transaction {} for location '{}'", (Object)transactionId, (Object)traceComponent);
        }
        if ((transaction = this.getTransaction(transactionId)) == null) {
            return null;
        }
        return transaction.endProcessorSpan(traceComponent, spanUpdater, endTime);
    }

    static {
        LOGGER = LoggerFactory.getLogger(InMemoryTransactionStore.class);
    }
}

