/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.util.memoizers;

import com.avioconsulting.mule.opentelemetry.internal.util.memoizers.AbstractMemoizer;
import java.util.Objects;
import java.util.function.BiFunction;

public class BiFunctionMemoizer<K, T, R>
extends AbstractMemoizer<K, R>
implements BiFunction<K, T, R> {
    private final BiFunction<K, T, R> function;

    public BiFunctionMemoizer(BiFunction<K, T, R> function) {
        this.function = Objects.requireNonNull(function);
    }

    public BiFunctionMemoizer(BiFunction<K, T, R> function, boolean supportNullValues) {
        super(supportNullValues);
        this.function = Objects.requireNonNull(function);
    }

    @Override
    public R apply(K k, T t) {
        Object cached = this.cache.computeIfAbsent(k, key -> {
            R computed = this.function.apply(key, t);
            if (computed == null && this.supportNullValues) {
                return this.NULL_VALUE;
            }
            return computed;
        });
        return (R)(cached == this.NULL_VALUE ? null : cached);
    }

    public static <K, T, R> BiFunctionMemoizer<K, T, R> memoize(BiFunction<K, T, R> function) {
        return new BiFunctionMemoizer<K, T, R>(function);
    }

    public static <K, T, R> BiFunctionMemoizer<K, T, R> memoize(BiFunction<K, T, R> function, boolean allowNullValues) {
        return new BiFunctionMemoizer<K, T, R>(function, allowNullValues);
    }
}

