/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.util.memoizers;

import com.avioconsulting.mule.opentelemetry.internal.util.memoizers.AbstractMemoizer;
import java.util.Objects;
import java.util.function.Function;

public class FunctionMemoizer<T, R>
extends AbstractMemoizer<T, R>
implements Function<T, R> {
    private final Function<T, R> function;

    public FunctionMemoizer(Function<T, R> function) {
        this.function = Objects.requireNonNull(function);
    }

    public FunctionMemoizer(Function<T, R> function, boolean supportNullValues) {
        super(supportNullValues);
        this.function = Objects.requireNonNull(function);
    }

    @Override
    public R apply(T input) {
        Objects.requireNonNull(input, "Memoizer Input cannot be null");
        Object cached = this.cache.computeIfAbsent(input, key -> {
            R computed = this.function.apply(key);
            if (computed == null && this.supportNullValues) {
                return this.NULL_VALUE;
            }
            return computed;
        });
        return (R)(cached == this.NULL_VALUE ? null : cached);
    }

    public static <T, R> FunctionMemoizer<T, R> memoize(Function<T, R> function) {
        return new FunctionMemoizer<T, R>(function);
    }

    public static <T, R> FunctionMemoizer<T, R> memoize(Function<T, R> function, boolean allowNullValues) {
        return new FunctionMemoizer<T, R>(function, allowNullValues);
    }
}

