/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api.config;

import com.avioconsulting.mule.opentelemetry.api.config.OtelConfigMapProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class SpanProcessorConfiguration
implements OtelConfigMapProvider {
    @Parameter
    @Placement(order=10, tab="Tracer Settings")
    @DisplayName(value="Max Queue Size")
    @Optional(defaultValue="4096")
    @Summary(value="The maximum number of spans in the waiting queue. Any new spans are dropped once the queue is full.")
    private long maxQueueSize;
    @Parameter
    @Placement(order=20, tab="Tracer Settings")
    @DisplayName(value="Max Batch Export Size")
    @Optional(defaultValue="1024")
    @Summary(value="The maximum number of spans to export in a single batch. This must be smaller or equal to Max Queue Size.")
    private long maxBatchExportSize;
    @Parameter
    @Placement(order=30, tab="Tracer Settings")
    @DisplayName(value="Batch Export Delay Interval")
    @Optional(defaultValue="1500")
    @Summary(value="The delay interval in milliseconds between two consecutive batch exports.")
    private long batchExportDelayInterval;
    @Parameter
    @Placement(order=40, tab="Tracer Settings")
    @DisplayName(value="Batch Export Timeout")
    @Optional(defaultValue="10000")
    @Summary(value="The Maximum number of milliseconds the exporter will wait for a batch to export before cancelling the export.")
    private long exportTimeout;

    public SpanProcessorConfiguration() {
    }

    public SpanProcessorConfiguration(long maxQueueSize, long maxBatchExportSize, long batchExportDelayInterval, long exportTimeout) {
        this.maxQueueSize = maxQueueSize;
        this.maxBatchExportSize = maxBatchExportSize;
        this.batchExportDelayInterval = batchExportDelayInterval;
        this.exportTimeout = exportTimeout;
    }

    public long getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public long getMaxBatchExportSize() {
        return this.maxBatchExportSize;
    }

    public long getBatchExportDelayInterval() {
        return this.batchExportDelayInterval;
    }

    public long getExportTimeout() {
        return this.exportTimeout;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanProcessorConfiguration that = (SpanProcessorConfiguration)o;
        return this.getMaxQueueSize() == that.getMaxQueueSize() && this.getMaxBatchExportSize() == that.getMaxBatchExportSize() && this.getBatchExportDelayInterval() == that.getBatchExportDelayInterval() && this.getExportTimeout() == that.getExportTimeout();
    }

    public int hashCode() {
        return Objects.hash(this.getMaxQueueSize(), this.getMaxBatchExportSize(), this.getBatchExportDelayInterval(), this.getExportTimeout());
    }

    @Override
    public Map<String, String> getConfigMap() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("otel.bsp.schedule.delay", String.valueOf(this.getBatchExportDelayInterval()));
        configMap.put("otel.bsp.max.queue.size", String.valueOf(this.getMaxQueueSize()));
        configMap.put("otel.bsp.max.export.batch.size", String.valueOf(this.getMaxBatchExportSize()));
        configMap.put("otel.bsp.export.timeout", String.valueOf(this.getExportTimeout()));
        return Collections.unmodifiableMap(configMap);
    }
}

