/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api.config.exporter;

import com.avioconsulting.mule.opentelemetry.api.config.Header;
import com.avioconsulting.mule.opentelemetry.api.config.KeyValuePair;
import com.avioconsulting.mule.opentelemetry.api.config.exporter.AbstractExporter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class OtlpExporter
extends AbstractExporter {
    public static final String OTLP = "otlp";
    public static final String OTEL_EXPORTER_OTLP_PROTOCOL = "otel.exporter.otlp.protocol";
    public static final String OTEL_EXPORTER_OTLP_ENDPOINT = "otel.exporter.otlp.endpoint";
    public static final String OTEL_EXPORTER_OTLP_TRACES_ENDPOINT = "otel.exporter.otlp.traces.endpoint";
    public static final String OTEL_EXPORTER_OTLP_METRICS_ENDPOINT = "otel.exporter.otlp.metrics.endpoint";
    public static final String OTEL_EXPORTER_OTLP_LOGS_ENDPOINT = "otel.exporter.otlp.logs.endpoint";
    public static final String OTEL_EXPORTER_OTLP_COMPRESSION = "otel.exporter.otlp.compression";
    public static final String OTEL_EXPORTER_OTLP_HEADERS = "otel.exporter.otlp.headers";
    public static final String OTEL_EXPORTER_OTLP_CERTIFICATE = "otel.exporter.otlp.certificate";
    public static final String OTEL_EXPORTER_OTLP_CLIENT_KEY = "otel.exporter.otlp.client.key";
    public static final String OTEL_EXPORTER_OTLP_CLIENT_CERTIFICATE = "otel.exporter.otlp.client.certificate";
    @Parameter
    @Optional
    @Summary(value="The OTLP traces, metrics, and logs endpoint to connect to. Must be a URL with a scheme of either http or https based on the use of TLS.GRPC Protocol may have URL like http://localhost:4317 and HTTP_PROTOBUF be like http://localhost:4318.")
    @Example(value="http://localhost:4317")
    private String collectorEndpoint;
    private String computedCollectorEndpoint;
    @Parameter
    @Optional(defaultValue="GRPC")
    @DisplayName(value="Collector Protocol")
    private Protocol protocol;
    @Parameter
    @Optional(defaultValue="NONE")
    @DisplayName(value="Request Compression")
    @Summary(value="The compression type to use on OTLP trace, metric, and log requests.")
    private OtlpRequestCompression requestCompression;
    @Parameter
    @Optional
    @Path(type=PathModel.Type.FILE, acceptedFileExtensions={"pem"}, location=PathModel.Location.EMBEDDED)
    @DisplayName(value="Endpoint Certificate Path")
    @Summary(value="The path to the file containing trusted certificates to use when verifying an OTLP trace, metric, or log server's TLS credentials. The file should contain one or more X.509 certificates in PEM format. By default the host platform's trusted root certificates are used.")
    private String endpointCertPath;
    @Parameter
    @Optional
    @Path(type=PathModel.Type.FILE, acceptedFileExtensions={"pem"}, location=PathModel.Location.EMBEDDED)
    @DisplayName(value="Client Certificate Path")
    @Summary(value="The path to the file containing trusted certificates to use when verifying an OTLP trace, metric, or log client's TLS credentials. The file should contain one or more X.509 certificates in PEM format. By default no chain file is used.")
    private String clientCertPath;
    @Parameter
    @Optional
    @Path(type=PathModel.Type.FILE, acceptedFileExtensions={"pem"}, location=PathModel.Location.EMBEDDED)
    @DisplayName(value="Client Certificate Key Path")
    @Summary(value="The path to the file containing private client key to use when verifying an OTLP trace, metric, or log client's TLS credentials. The file should contain one private key PKCS8 PEM format. By default no client key is used.")
    private String clientCertKeyPath;
    @Parameter
    @DisplayName(value="Headers")
    @Optional
    @NullSafe
    @Summary(value="Key-value pairs separated by commas to pass as request headers on OTLP trace, metric, and log requests.")
    private List<Header> headers;

    public List<Header> getHeaders() {
        return this.headers;
    }

    public OtlpRequestCompression getRequestCompression() {
        return this.requestCompression;
    }

    public String getCollectorEndpoint() {
        if (this.computedCollectorEndpoint != null) {
            return this.computedCollectorEndpoint;
        }
        this.computedCollectorEndpoint = Protocol.HTTP_PROTOBUF.equals((Object)this.protocol) && !this.collectorEndpoint.toLowerCase().endsWith("/v1") ? this.collectorEndpoint + "/v1" : this.collectorEndpoint;
        return this.computedCollectorEndpoint;
    }

    public String getEndpointCertPath() {
        return this.endpointCertPath;
    }

    public String getClientCertPath() {
        return this.clientCertPath;
    }

    public String getClientCertKeyPath() {
        return this.clientCertKeyPath;
    }

    public OtlpExporter() {
    }

    OtlpExporter(String collectorEndpoint, Protocol protocol, OtlpRequestCompression requestCompression, List<Header> headers) {
        this(collectorEndpoint, protocol, requestCompression, headers, null, null, null);
    }

    OtlpExporter(String collectorEndpoint, Protocol protocol, OtlpRequestCompression requestCompression, List<Header> headers, String endpointCertPath, String clientCertKeyPath, String clientCertPath) {
        this.collectorEndpoint = collectorEndpoint;
        this.protocol = protocol;
        this.requestCompression = requestCompression;
        this.headers = headers;
        this.endpointCertPath = endpointCertPath;
        this.clientCertPath = clientCertPath;
        this.clientCertKeyPath = clientCertKeyPath;
    }

    @Override
    public Map<String, String> getExporterProperties() {
        Map<String, String> config = super.getExporterProperties();
        config.put("otel.traces.exporter", OTLP);
        config.put("otel.metrics.exporter", OTLP);
        config.put("otel.logs.exporter", OTLP);
        config.put(OTEL_EXPORTER_OTLP_PROTOCOL, this.protocol.getValue());
        config.put(OTEL_EXPORTER_OTLP_ENDPOINT, this.getCollectorEndpoint());
        if (this.protocol.equals((Object)Protocol.HTTP_PROTOBUF)) {
            config.put(OTEL_EXPORTER_OTLP_TRACES_ENDPOINT, this.getSignalEndpoint("traces"));
            config.put(OTEL_EXPORTER_OTLP_METRICS_ENDPOINT, this.getSignalEndpoint("metrics"));
            config.put(OTEL_EXPORTER_OTLP_LOGS_ENDPOINT, this.getSignalEndpoint("logs"));
        }
        if (!OtlpRequestCompression.NONE.equals((Object)this.requestCompression)) {
            config.put(OTEL_EXPORTER_OTLP_COMPRESSION, this.requestCompression.getValue());
        }
        config.put(OTEL_EXPORTER_OTLP_HEADERS, KeyValuePair.commaSeparatedList(this.getHeaders()));
        if (this.getEndpointCertPath() != null) {
            config.put(OTEL_EXPORTER_OTLP_CERTIFICATE, this.transformToAbsolutePath(OTEL_EXPORTER_OTLP_CERTIFICATE, this.getEndpointCertPath()));
        }
        if (this.getClientCertKeyPath() != null) {
            config.put(OTEL_EXPORTER_OTLP_CLIENT_KEY, this.transformToAbsolutePath(OTEL_EXPORTER_OTLP_CLIENT_KEY, this.getClientCertKeyPath()));
        }
        if (this.getClientCertPath() != null) {
            config.put(OTEL_EXPORTER_OTLP_CLIENT_CERTIFICATE, this.transformToAbsolutePath(OTEL_EXPORTER_OTLP_CLIENT_CERTIFICATE, this.getClientCertPath()));
        }
        return config;
    }

    private String getSignalEndpoint(String signal) {
        String endpoint = this.getCollectorEndpoint();
        if (!endpoint.endsWith("/")) {
            endpoint = endpoint.concat("/");
        }
        return endpoint.concat(signal);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtlpExporter that = (OtlpExporter)o;
        return Objects.equals(this.collectorEndpoint, that.collectorEndpoint) && this.protocol == that.protocol && Objects.equals(this.headers, that.headers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.collectorEndpoint, this.protocol, this.headers});
    }

    public static enum OtlpRequestCompression {
        NONE("none"),
        GZIP("gzip");

        private final String value;
        private static Map<String, OtlpRequestCompression> compressions;

        private OtlpRequestCompression(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        OtlpRequestCompression fromValue(String value) {
            return compressions.get(value);
        }

        static {
            compressions = Arrays.stream(OtlpRequestCompression.values()).collect(Collectors.toMap(OtlpRequestCompression::getValue, Function.identity()));
        }
    }

    public static enum Protocol {
        GRPC("grpc"),
        HTTP_PROTOBUF("http/protobuf");

        private final String value;
        private static Map<String, Protocol> protocols;

        private Protocol(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        Protocol fromValue(String value) {
            return protocols.get(value);
        }

        static {
            protocols = Arrays.stream(Protocol.values()).collect(Collectors.toMap(Protocol::getValue, Function.identity()));
        }
    }
}

