/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api.util;

public class EncodingUtil {
    public static long spanIdHexToLong(String hex) {
        long result = 0L;
        for (int i = 0; i < 16; ++i) {
            result = result << 4 | (long)EncodingUtil.digitValue(hex.charAt(i));
        }
        return result;
    }

    public static long traceIdHexToLowLong(String hex) {
        long low = 0L;
        for (int i = 16; i < 32; ++i) {
            low = low << 4 | (long)EncodingUtil.digitValue(hex.charAt(i));
        }
        return low;
    }

    public static void traceIdHexToLongs(String hex, long[] output) {
        int i;
        long high = 0L;
        long low = 0L;
        for (i = 0; i < 16; ++i) {
            high = high << 4 | (long)EncodingUtil.digitValue(hex.charAt(i));
        }
        for (i = 16; i < 32; ++i) {
            low = low << 4 | (long)EncodingUtil.digitValue(hex.charAt(i));
        }
        output[0] = high;
        output[1] = low;
    }

    private static int digitValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    public static String longFromBase16Hex(String inputHex) {
        long longValue = Long.parseUnsignedLong(inputHex, 16);
        return Long.toUnsignedString(longValue);
    }

    public static String[] traceIdLong(String inputHex) {
        String hiLong = EncodingUtil.longFromBase16Hex(inputHex.substring(0, 16));
        String lowLong = EncodingUtil.longFromBase16Hex(inputHex.substring(16));
        return new String[]{hiLong, lowLong};
    }
}

