/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.interceptor;

import com.avioconsulting.mule.opentelemetry.api.config.MuleComponent;
import com.avioconsulting.mule.opentelemetry.api.config.TraceLevelConfiguration;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleCoreProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ComponentRegistryService;
import com.avioconsulting.mule.opentelemetry.internal.util.BatchHelperUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptorProcessorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterceptorProcessorConfig.class);
    public static final String MULE_OTEL_INTERCEPTOR_PROCESSOR_ENABLE_PROPERTY_NAME = "mule.otel.interceptor.processor.enable";
    private final boolean INTERCEPTOR_ENABLED_BY_SYS_PROPERTY = PropertiesUtil.getBoolean("mule.otel.interceptor.processor.enable", true);
    public static final String MULE_OTEL_INTERCEPTOR_ENABLED_PROCESSORS = "mule.otel.interceptor.enabled.processors";
    private final String interceptorEnabledProcessors = PropertiesUtil.getProperty("mule.otel.interceptor.enabled.processors");
    public static final String MULE_OTEL_INTERCEPTOR_DISABLED_PROCESSORS = "mule.otel.interceptor.disabled.processors";
    private final String interceptorDisabledProcessors = PropertiesUtil.getProperty("mule.otel.interceptor.disabled.processors");
    public static final String MULE_OTEL_INTERCEPTOR_CONTEXT_ENABLED_PROCESSORS = "mule.otel.interceptor.context.enabled.processors";
    private final String contextEnabledProcessors = PropertiesUtil.getProperty("mule.otel.interceptor.context.enabled.processors");
    public static final String MULE_OTEL_INTERCEPTOR_CONTEXT_DISABLED_PROCESSORS = "mule.otel.interceptor.context.disabled.processors";
    private final String contextDisabledProcessors = PropertiesUtil.getProperty("mule.otel.interceptor.context.disabled.processors");
    public static final String MULE_OTEL_INTERCEPTOR_FIRST_PROCESSOR_ONLY = "mule.otel.interceptor.first.processor.only";
    private final boolean NOT_FIRST_PROCESSOR_ONLY_MODE = !PropertiesUtil.getBoolean("mule.otel.interceptor.first.processor.only", false);
    private boolean turnOffTracing = false;
    private final ConcurrentHashMap<String, Boolean> shouldInterceptCacheMap = new ConcurrentHashMap();
    private final Set<String> interceptInclusions = new HashSet<String>();
    private final Set<String> propagationRequiredComponents = new HashSet<String>();
    private ComponentRegistryService componentRegistryService;
    private Set<String> interceptDisabledByConfigComponents = new HashSet<String>();
    private Set<String> interceptEnabledByConfigComponents = new HashSet<String>();

    public InterceptorProcessorConfig setTurnOffTracing(boolean turnOffTracing) {
        this.turnOffTracing = turnOffTracing;
        return this;
    }

    public InterceptorProcessorConfig setComponentRegistryService(ComponentRegistryService componentRegistryService) {
        this.componentRegistryService = componentRegistryService;
        return this;
    }

    public InterceptorProcessorConfig() {
        this.setupInterceptComponents();
    }

    @Deprecated
    public void updateTraceConfiguration(TraceLevelConfiguration traceLevelConfiguration) {
        this.interceptDisabledByConfigComponents = traceLevelConfiguration.getInterceptionDisabledComponents().stream().map(MuleComponent::toString).collect(Collectors.toSet());
        this.interceptEnabledByConfigComponents = traceLevelConfiguration.getInterceptionEnabledComponents().stream().map(MuleComponent::toString).collect(Collectors.toSet());
    }

    private void setupInterceptComponents() {
        Set<String> processors;
        MuleCoreProcessorComponent.CORE_INTERCEPT_SCOPE_ROUTERS.forEach(c -> this.interceptInclusions.add("mule:" + c));
        if (this.interceptorEnabledProcessors != null && !this.interceptorEnabledProcessors.trim().isEmpty()) {
            processors = this.splitByComma(this.interceptorEnabledProcessors);
            this.interceptEnabledByConfigComponents.addAll(processors);
        }
        if (this.interceptorDisabledProcessors != null && !this.interceptorDisabledProcessors.trim().isEmpty()) {
            processors = this.splitByComma(this.interceptorDisabledProcessors);
            this.interceptDisabledByConfigComponents.addAll(processors);
        }
        this.setupContextPropagationRequiredComponents();
    }

    private void setupContextPropagationRequiredComponents() {
        try {
            Set<String> processors;
            InputStream interceptedComponentsFile = IOUtils.getResourceAsStream((String)"com/avioconsulting/mule/opentelemetry/internal/interceptor/intercept-components.txt", InterceptorProcessorConfig.class);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(interceptedComponentsFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("*")) continue;
                    String[] split = line.split(":");
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Attempting to add component to intercept: {}", (Object)line);
                    }
                    if (split.length == 2) {
                        this.interceptInclusions.add(line);
                        this.propagationRequiredComponents.add(line);
                        continue;
                    }
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn("Unable to parse intercept components entry: {}, skipping this line", (Object)line);
                }
            }
            if (this.contextEnabledProcessors != null && !this.contextEnabledProcessors.trim().isEmpty()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Intercepting additional processor configured with sys/env property {} : {}", (Object)MULE_OTEL_INTERCEPTOR_CONTEXT_ENABLED_PROCESSORS, (Object)this.contextEnabledProcessors);
                }
                processors = this.splitByComma(this.contextEnabledProcessors);
                this.interceptInclusions.addAll(processors);
                this.propagationRequiredComponents.addAll(processors);
            }
            if (this.contextDisabledProcessors != null && !this.contextDisabledProcessors.trim().isEmpty()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Removing processor configured with sys/env property {} from interception: {}", (Object)MULE_OTEL_INTERCEPTOR_CONTEXT_ENABLED_PROCESSORS, (Object)this.contextEnabledProcessors);
                }
                processors = this.splitByComma(this.contextDisabledProcessors);
                this.propagationRequiredComponents.removeAll(processors);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load interceptor components", e);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.debug("Final list of Context Intercepted components: {}", this.propagationRequiredComponents);
        }
    }

    private Set<String> splitByComma(String input) {
        return Arrays.stream(input.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
    }

    public boolean shouldIntercept(ComponentLocation location, Event event) {
        try {
            return this.shouldInterceptCacheMap.computeIfAbsent(location.getLocation(), key -> this.computeInterception(location, event));
        }
        catch (Exception e) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Exception occurred while computing interception for component {}. Returning false.", (Object)location.getComponentIdentifier().getIdentifier().getName(), (Object)e);
            }
            return false;
        }
    }

    private boolean computeInterception(ComponentLocation location, Event event) {
        if (!this.interceptorFeatureEnabled()) {
            return false;
        }
        if (event != null && BatchHelperUtil.shouldSkipThisBatchProcessing(event)) {
            return false;
        }
        return ComponentsUtil.isFirstProcessor(location) || BatchHelperUtil.isBatchStepFirstProcessor(location, event, this.componentRegistryService) || this.NOT_FIRST_PROCESSOR_ONLY_MODE && this.shouldIntercept(location.getComponentIdentifier().getIdentifier());
    }

    private boolean interceptorFeatureEnabled() {
        if (!this.INTERCEPTOR_ENABLED_BY_SYS_PROPERTY) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Interceptors are disabled by system property");
            }
            return false;
        }
        if (this.turnOffTracing) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Tracing has been turned off by global configuration");
            }
            return false;
        }
        return true;
    }

    public boolean interceptAround(ComponentLocation location) {
        if (!this.interceptorFeatureEnabled()) {
            return false;
        }
        String identifier = location.getComponentIdentifier().getIdentifier().getNamespace() + ":" + location.getComponentIdentifier().getIdentifier().getName();
        boolean intercept = this.propagationRequiredComponents.contains(identifier);
        if (intercept && LOGGER.isTraceEnabled()) {
            LOGGER.trace("Component {} is configured for context propagation, will intercept", (Object)identifier);
        }
        return intercept;
    }

    private boolean shouldIntercept(ComponentIdentifier componentIdentifier) {
        String identifier = componentIdentifier.getNamespace() + ":" + componentIdentifier.getName();
        String wildcardIdentifier = componentIdentifier.getNamespace() + ":*";
        if (this.interceptDisabledByConfigComponents.contains(wildcardIdentifier) && !this.interceptEnabledByConfigComponents.contains(identifier) || this.interceptDisabledByConfigComponents.contains(identifier)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Component {} is disabled by global configuration", (Object)identifier);
            }
            return false;
        }
        if (this.interceptInclusions.contains(identifier)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Component {} is enabled by default configuration", (Object)identifier);
            }
            return true;
        }
        if (this.interceptEnabledByConfigComponents.contains(wildcardIdentifier) || this.interceptEnabledByConfigComponents.contains(identifier)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Component {} is enabled by global configuration", (Object)identifier);
            }
            return true;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Component {} is not configured for interception, skipping interception", (Object)identifier);
        }
        return false;
    }
}

