/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.interceptor;

import com.avioconsulting.mule.opentelemetry.api.processor.ProcessorComponent;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ComponentRegistryService;
import com.avioconsulting.mule.opentelemetry.internal.util.BatchHelperUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.MDCUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import java.util.Map;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ProcessorTracingInterceptor
implements ProcessorInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorTracingInterceptor.class);
    private final MuleNotificationProcessor muleNotificationProcessor;
    private final ComponentRegistryService componentRegistryService;

    public ProcessorTracingInterceptor(MuleNotificationProcessor muleNotificationProcessor) {
        this.muleNotificationProcessor = muleNotificationProcessor;
        this.componentRegistryService = muleNotificationProcessor.getComponentRegistryService();
    }

    public void before(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event) {
        block28: {
            try {
                if (!this.muleNotificationProcessor.getInterceptorProcessorConfig().shouldIntercept(location, (Event)event)) {
                    return;
                }
                if (!this.muleNotificationProcessor.hasConnection()) break block28;
                ProcessorComponent processorComponent = this.muleNotificationProcessor.getProcessorComponent(location.getComponentIdentifier().getIdentifier());
                this.switchTraceContext(event, "OTEL_TRACE_CONTEXT", "OTEL_PREV_TRACE_CONTEXT");
                if (ComponentsUtil.isFirstProcessor(location)) {
                    this.switchTraceContext(event, "_OTEL_FLOW_CONTEXT_ID", "_OTEL_FLOW_PREV_CONTEXT_ID");
                    event.addVariable("_OTEL_FLOW_CONTEXT_ID", (Object)event.getContext().getId());
                }
                if (processorComponent == null) {
                    String transactionId = OpenTelemetryUtil.getEventTransactionId((Event)event);
                    this.addTraceContextMap(event, this.muleNotificationProcessor.getOpenTelemetryConnection().getTraceContext(transactionId));
                } else {
                    Component component = this.componentRegistryService.findComponentByLocation(location);
                    if (component == null) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Could not locate a component for {} at {}", (Object)location.getComponentIdentifier().getIdentifier(), (Object)location.getLocation());
                        }
                        this.switchTraceContext(event, "OTEL_PREV_TRACE_CONTEXT", "OTEL_TRACE_CONTEXT");
                        return;
                    }
                    try (TraceComponent traceComponent = processorComponent.getStartTraceComponent(component, (Event)event);){
                        if (traceComponent == null) {
                            LOGGER.warn("Could not build a trace component for {} at {}", (Object)location.getComponentIdentifier().getIdentifier(), (Object)location.getLocation());
                            this.switchTraceContext(event, "OTEL_PREV_TRACE_CONTEXT", "OTEL_TRACE_CONTEXT");
                            return;
                        }
                        BatchHelperUtil.addBatchTags(traceComponent, (Event)event);
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("Creating Span in the interceptor for {} at {}", (Object)location.getComponentIdentifier().getIdentifier(), (Object)location.getLocation());
                        }
                        OpenTelemetryUtil.resolveExpressions(traceComponent, this.muleNotificationProcessor.getOpenTelemetryConnection().getExpressionManager(), (Event)event);
                        this.muleNotificationProcessor.getOpenTelemetryConnection().addProcessorSpan(traceComponent, ComponentsUtil.getLocationParent(location.getLocation()));
                        String transactionId = OpenTelemetryUtil.getEventTransactionId((Event)event);
                        if (ComponentsUtil.isFlowRef(location)) {
                            this.processFlowRef(location, event, traceComponent, transactionId);
                        } else {
                            this.addTraceContextMap(event, this.muleNotificationProcessor.getOpenTelemetryConnection().getTraceContext(transactionId, traceComponent.contextScopedLocation()));
                        }
                    }
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Intercepted with logic '{}' at '{}'", (Object)location.getComponentIdentifier().getIdentifier().toString(), (Object)location.getLocation());
                }
            }
            catch (Exception ex) {
                if (!LOGGER.isTraceEnabled()) break block28;
                LOGGER.trace("Failed to intercept processor {} at {}, span may not be captured for this processor. Error - {}", new Object[]{location.getComponentIdentifier().getIdentifier().toString(), location.getLocation(), ex.getLocalizedMessage(), ex});
            }
        }
    }

    private void addTraceContextMap(InterceptionEvent event, Map<String, Object> contextMap) {
        event.addVariable("OTEL_TRACE_CONTEXT", contextMap);
        MDCUtil.replaceMDCOtelEntries(contextMap);
    }

    private void processFlowRef(ComponentLocation location, InterceptionEvent event, TraceComponent traceComponent, String transactionId) {
        ComponentLocation subFlowLocation = ComponentsUtil.resolveFlowName(this.muleNotificationProcessor.getOpenTelemetryConnection().getExpressionManager(), traceComponent, () -> ((InterceptionEvent)event).asBindingContext(), this.componentRegistryService);
        if (subFlowLocation != null) {
            try (TraceComponent subflowTrace = ComponentsUtil.getSubFlowTraceComponent(subFlowLocation, traceComponent);){
                this.muleNotificationProcessor.getOpenTelemetryConnection().addProcessorSpan(subflowTrace, location.getLocation());
                this.addTraceContextMap(event, this.muleNotificationProcessor.getOpenTelemetryConnection().getTraceContext(transactionId, subflowTrace.contextScopedLocation()));
            }
        } else {
            this.addTraceContextMap(event, this.muleNotificationProcessor.getOpenTelemetryConnection().getTraceContext(transactionId, traceComponent.contextScopedLocation()));
        }
    }

    public void after(ComponentLocation location, InterceptionEvent event, Optional<Throwable> thrown) {
        this.switchTraceContext(event, "OTEL_PREV_TRACE_CONTEXT", "OTEL_TRACE_CONTEXT");
        if (ComponentsUtil.isFlowRef(location)) {
            this.switchTraceContext(event, "_OTEL_FLOW_PREV_CONTEXT_ID", "_OTEL_FLOW_CONTEXT_ID");
        }
        if (location.getComponentIdentifier().getIdentifier().toString().equals("batch:job")) {
            event.addVariable("_OTEL_BATCH_PARENT_CONTEXT_ID", (Object)OpenTelemetryUtil.getEventTransactionId(event.getContext().getId()));
        }
        if (BatchHelperUtil.isBatchStepFirstProcessor(location, (Event)event, this.componentRegistryService)) {
            event.addVariable("OTEL_BATCH_STEP_RECORD_CONTEXT_ID", (Object)event.getContext().getId());
            event.removeVariable("_OTEL_BATCH_PARENT_CONTEXT_ID");
        }
    }

    private void switchTraceContext(InterceptionEvent event, String removalContextKey, String newContextKey) {
        if (event.getVariables().containsKey(removalContextKey)) {
            TypedValue prevContext = (TypedValue)event.getVariables().get(removalContextKey);
            if (removalContextKey.equalsIgnoreCase("OTEL_PREV_TRACE_CONTEXT")) {
                Map contextMap = (Map)prevContext.getValue();
                MDCUtil.replaceMDCOtelEntries(contextMap);
            }
            event.addVariable(newContextKey, (Object)prevContext);
            event.removeVariable(removalContextKey);
        }
    }
}

