/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.interceptor;

import com.avioconsulting.mule.opentelemetry.internal.interceptor.InterceptorProcessorConfig;
import com.avioconsulting.mule.opentelemetry.internal.interceptor.ProcessorTracingInterceptor;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessorTracingInterceptorFactory
implements ProcessorInterceptorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorTracingInterceptorFactory.class);
    private final boolean interceptorEnabled = PropertiesUtil.getBoolean("mule.otel.interceptor.processor.enable", true);
    private final boolean NOT_FIRST_PROCESSOR_ONLY_MODE = !PropertiesUtil.getBoolean("mule.otel.interceptor.first.processor.only", false);
    private final InterceptorProcessorConfig interceptorProcessorConfig;
    private final ProcessorTracingInterceptor processorTracingInterceptor;

    @Inject
    public ProcessorTracingInterceptorFactory(MuleNotificationProcessor muleNotificationProcessor) {
        this.processorTracingInterceptor = new ProcessorTracingInterceptor(muleNotificationProcessor);
        this.interceptorProcessorConfig = muleNotificationProcessor.getInterceptorProcessorConfig();
    }

    public ProcessorInterceptor get() {
        return this.processorTracingInterceptor;
    }

    public boolean intercept(ComponentLocation location) {
        boolean intercept = this.interceptorProcessorConfig.shouldIntercept(location, null);
        if (LOGGER.isTraceEnabled() && intercept) {
            LOGGER.trace("Will Intercept '{}::{}'", (Object)location.getRootContainerName(), (Object)location.getLocation());
        }
        return intercept;
    }
}

