/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk;

import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.resources.ContainerResource;
import io.opentelemetry.instrumentation.resources.HostResource;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.incubating.ContainerIncubatingAttributes;
import io.opentelemetry.semconv.incubating.HostIncubatingAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MuleAppHostResource {
    private static final String MULE_OTEL_SERVICE_HOST_CHV_1_STRATEGY = "mule.otel.service.host.chv1.strategy";
    private static Resource INSTANCE = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleAppHostResource.class);

    public static Resource get(ConfigProperties config) {
        return MuleAppHostResource.getInternal(config);
    }

    private static synchronized Resource getInternal(ConfigProperties config) {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = MuleAppHostResource.buildResource(config);
        return INSTANCE;
    }

    public static void refresh(ConfigProperties configProperties) {
        INSTANCE = MuleAppHostResource.buildResource(configProperties);
    }

    private static Resource buildResource(ConfigProperties config) {
        AttributesBuilder attributes = Attributes.builder();
        if (PropertiesUtil.isCloudHubV2()) {
            Resource containerResource = ContainerResource.get();
            OpenTelemetryUtil.addAttribute("NODE_NAME", attributes, (AttributeKey<String>)HostIncubatingAttributes.HOST_NAME);
            attributes.putAll(containerResource.getAttributes());
            OpenTelemetryUtil.addAttribute("HOSTNAME", attributes, (AttributeKey<String>)ContainerIncubatingAttributes.CONTAINER_NAME);
        } else if (PropertiesUtil.isCloudHubV1()) {
            String hostStrategy;
            Resource hostResource = HostResource.get();
            String workerPublicIP = PropertiesUtil.getProperty("worker.publicIP");
            String hostname = (String)hostResource.getAttribute(HostIncubatingAttributes.HOST_NAME);
            if (workerPublicIP != null) {
                attributes.put(HostIncubatingAttributes.HOST_IP, (Object[])new String[]{workerPublicIP});
                hostname = "ip-" + workerPublicIP.replace(".", "-");
            }
            switch (hostStrategy = config.getString(MULE_OTEL_SERVICE_HOST_CHV_1_STRATEGY, "")) {
                case "service_name": {
                    hostname = config.getString("otel.service.name");
                    break;
                }
                case "env_id": {
                    hostname = PropertiesUtil.getProperty("environment.id");
                    break;
                }
                case "": {
                    break;
                }
                default: {
                    if (!LOGGER.isWarnEnabled()) break;
                    LOGGER.warn("Invalid mule.otel.service.host.chv1.strategy value: {}", (Object)hostStrategy);
                }
            }
            if (hostname != null) {
                attributes.put(HostIncubatingAttributes.HOST_NAME, (Object)hostname);
            }
            String workerId = PropertiesUtil.getProperty("worker.id", "na");
            String container = String.format("%s-%s", PropertiesUtil.getProperty("domain"), workerId);
            attributes.put(ContainerIncubatingAttributes.CONTAINER_NAME, (Object)container);
            attributes.put(ContainerIncubatingAttributes.CONTAINER_ID, (Object)container);
        } else {
            Resource hostResource = HostResource.get();
            attributes.putAll(hostResource.getAttributes());
        }
        return Resource.create((Attributes)attributes.build());
    }

    private MuleAppHostResource() {
    }
}

