/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ComponentRegistryService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentWrapper {
    public static final String COMPONENT_NAMESPACE_KEY = "component:namespace";
    public static final String COMPONENT_NAME_KEY = "component:name";
    private final Component component;
    private final Map<String, String> parameters;
    private final Map<String, String> configParameters;
    private final Map<String, String> connectionParameters;
    private final ComponentRegistryService componentRegistryService;
    private String defaultSpanName;
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentWrapper.class);
    private final Map<String, String> staticParameters;

    public ComponentWrapper(Component component, ComponentRegistryService componentRegistryService) {
        this.component = component;
        this.componentRegistryService = componentRegistryService;
        Map componentAnnotation = (Map)this.getComponentAnnotation("{config}componentParameters");
        this.parameters = componentAnnotation != null ? Collections.unmodifiableMap(componentAnnotation) : Collections.emptyMap();
        this.configParameters = Collections.unmodifiableMap(this.initConfigMap());
        this.connectionParameters = Collections.unmodifiableMap(this.initConnectionParameters());
        this.setDefaultSpanName(component);
        this.staticParameters = this.setStaticParameters();
    }

    private Map<String, String> setStaticParameters() {
        HashMap<String, String> staticParameters = new HashMap<String, String>();
        staticParameters.put(SemanticAttributes.MULE_APP_PROCESSOR_NAMESPACE.getKey(), this.component.getIdentifier().getNamespace());
        staticParameters.put(SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey(), this.component.getIdentifier().getName());
        if (this.getDocName() != null) {
            staticParameters.put(SemanticAttributes.MULE_APP_PROCESSOR_DOC_NAME.getKey(), this.getDocName());
        }
        if (this.getConfigRef() != null) {
            staticParameters.put(SemanticAttributes.MULE_APP_PROCESSOR_CONFIG_REF.getKey(), this.getConfigRef());
            staticParameters.putAll(this.componentRegistryService.getGlobalConfigOtelSystemProperties(this.getConfigRef()));
        }
        return Collections.unmodifiableMap(staticParameters);
    }

    public Map<String, String> staticParametersAsReadOnlyMap() {
        return this.staticParameters;
    }

    private void setDefaultSpanName(Component component) {
        String name = component.getLocation().getComponentIdentifier().getIdentifier().getNamespace();
        this.defaultSpanName = name.equalsIgnoreCase("apikit") ? component.getIdentifier().getName() + ":" + (this.getDocName() == null ? component.getIdentifier().getName() : this.getDocName()) + " " + this.getConfigRef() : (name.equalsIgnoreCase("anypoint-mq") ? this.getParameter("destination") + " publish" : (name.equalsIgnoreCase("wsc") ? this.getConfigConnectionParameters().get("service") + ":" + this.getParameter("operation") : component.getIdentifier().getName() + ":" + (this.getDocName() == null ? component.getIdentifier().getName() : this.getDocName())));
    }

    public String getDefaultSpanName() {
        return this.defaultSpanName;
    }

    public Component getComponent() {
        return this.component;
    }

    private <T> T getComponentAnnotation(String annotationName) {
        return (T)this.component.getAnnotation(QName.valueOf(annotationName));
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getName() {
        return this.parameters.get("name");
    }

    public String getParameter(String parameter) {
        return this.parameters.get(parameter);
    }

    public String getConfigRef() {
        return this.parameters.get("config-ref");
    }

    public String getDocName() {
        return this.parameters.get("doc:name");
    }

    public Map<String, String> getConfigConnectionParameters() {
        return this.connectionParameters;
    }

    private Map<String, String> initConnectionParameters() {
        String componentConfigRef = this.getConfigRef();
        if (componentConfigRef == null) {
            return Collections.emptyMap();
        }
        try {
            Component component = this.componentRegistryService.findComponentByLocation(Location.builder().globalName(componentConfigRef).addConnectionPart().build().toString());
            if (component == null) {
                return Collections.emptyMap();
            }
            return this.toExtendedParameters(new ComponentWrapper(component, this.componentRegistryService));
        }
        catch (Exception ex) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Failed to extract connection parameters for {}. Ignoring this failure - {}", (Object)componentConfigRef, (Object)ex.getMessage());
            }
            return Collections.emptyMap();
        }
    }

    public Map<String, String> getConfigParameters() {
        return this.configParameters;
    }

    private Map<String, String> initConfigMap() {
        String componentConfigRef = this.getConfigRef();
        if (componentConfigRef == null) {
            return Collections.emptyMap();
        }
        try {
            Component component = this.componentRegistryService.findComponentByLocation(Location.builder().globalName(componentConfigRef).build().toString());
            if (component == null) {
                return Collections.emptyMap();
            }
            return this.toExtendedParameters(new ComponentWrapper(component, this.componentRegistryService));
        }
        catch (Exception ex) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Failed to extract connection parameters for {}. Ignoring this failure - {}", (Object)componentConfigRef, (Object)ex.getMessage());
            }
            return Collections.emptyMap();
        }
    }

    private Map<String, String> toExtendedParameters(ComponentWrapper componentWrapper) {
        HashMap<String, String> map = new HashMap<String, String>(componentWrapper.getParameters());
        map.put(COMPONENT_NAMESPACE_KEY, componentWrapper.getComponent().getIdentifier().getNamespace());
        map.put(COMPONENT_NAME_KEY, componentWrapper.getComponent().getIdentifier().getName());
        return map;
    }

    public String toString() {
        return "ComponentWrapper{parameters=" + this.parameters + ", configParameters=" + this.configParameters + ", connectionParameters=" + this.connectionParameters + ", defaultSpanName='" + this.defaultSpanName + '\'' + ", staticParameters=" + this.staticParameters + ", component=" + this.component + '}';
    }
}

