/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;

public class MuleCoreProcessorComponent
extends AbstractProcessorComponent {
    public static final List<String> CORE_INTERCEPT_SCOPE_ROUTERS = Arrays.asList("flow-ref", "choice", "first-successful", "until-successful", "scatter-gather", "round-robin", "foreach", "parallel-foreach", "try");
    private static List<String> CORE_PROCESSORS;

    @Override
    protected String getNamespace() {
        return "mule";
    }

    @Override
    protected List<String> getOperations() {
        return CORE_PROCESSORS;
    }

    @Override
    protected List<String> getSources() {
        return Collections.emptyList();
    }

    public MuleCoreProcessorComponent() {
        CORE_PROCESSORS = new ArrayList<String>(CORE_INTERCEPT_SCOPE_ROUTERS);
        CORE_PROCESSORS.add("async");
    }

    @Override
    public boolean canHandle(ComponentIdentifier componentIdentifier) {
        return super.canHandle(componentIdentifier);
    }

    @Override
    protected <A> void addAttributes(Component component, TypedValue<A> attributes, TraceComponent collector) {
        ComponentWrapper componentWrapper = this.componentRegistryService.getComponentWrapper(component);
        if (ComponentsUtil.isFlowRef(component.getLocation())) {
            collector.addTag(SemanticAttributes.MULE_APP_PROCESSOR_FLOW_REF_NAME.getKey(), componentWrapper.getParameter("name"));
        }
    }

    @Override
    public TraceComponent getEndTraceComponent(EnrichedServerNotification notification) {
        TraceComponent endTraceComponent = super.getEndTraceComponent(notification);
        ComponentWrapper componentWrapper = this.componentRegistryService.getComponentWrapper(notification.getComponent());
        if (ComponentsUtil.isFlowRef(notification.getComponent().getLocation())) {
            endTraceComponent.addTag(SemanticAttributes.MULE_APP_PROCESSOR_FLOW_REF_NAME.getKey(), componentWrapper.getParameter("name"));
        }
        return endTraceComponent;
    }
}

