/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor.util;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.Taggable;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.memoizers.FunctionMemoizer;
import io.opentelemetry.semconv.HttpAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class HttpSpanUtil {
    private static final Map<String, String> HTTP_METHODS = new HashMap<String, String>(10, 1.0f);
    private static final ConcurrentHashMap<String, String> HTTP_SPAN_NAME_CACHE = new ConcurrentHashMap();
    private static final FunctionMemoizer<String, String> apiKitRoutePathExtractorMemoizer;

    public static String method(Taggable<String, String> tags) {
        return Objects.requireNonNull(tags.getTag(HttpAttributes.HTTP_REQUEST_METHOD.getKey()), "HTTP Method must not be null");
    }

    public static String spanName(Taggable<String, String> tags, String route) {
        return HttpSpanUtil.spanName(HttpSpanUtil.method(tags), route);
    }

    public static String spanName(String method, String route) {
        if (!PropertiesUtil.isUseAPIKitSpanNames()) {
            return route;
        }
        String key = method + route;
        return HTTP_SPAN_NAME_CACHE.computeIfAbsent(key, k -> {
            if (HTTP_METHODS.containsKey(method)) {
                return HTTP_METHODS.get(method) + " " + route;
            }
            return method.toUpperCase() + " " + route;
        });
    }

    public static String apiKitRoutePath(Taggable<String, String> tags) {
        String flowName = tags.getTag(SemanticAttributes.MULE_APP_FLOW_NAME.getKey());
        return apiKitRoutePathExtractorMemoizer.apply(flowName);
    }

    private static String apiKitRoutePathExtractor(String flowName) {
        Objects.requireNonNull(flowName, "Flow name must not be null");
        int pathStart = flowName.indexOf(58) + 1;
        if (pathStart == 0) {
            throw new RuntimeException("Invalid flow name format: " + flowName);
        }
        int pathEnd = flowName.indexOf(58, pathStart);
        if (pathEnd == -1) {
            pathEnd = flowName.length();
        }
        StringBuilder result = new StringBuilder(pathEnd - pathStart);
        block5: for (int i = pathStart; i < pathEnd; ++i) {
            char c = flowName.charAt(i);
            switch (c) {
                case '\\': {
                    result.append('/');
                    continue block5;
                }
                case '(': {
                    result.append('{');
                    continue block5;
                }
                case ')': {
                    result.append('}');
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    static {
        HTTP_METHODS.put("connect", "CONNECT");
        HTTP_METHODS.put("delete", "DELETE");
        HTTP_METHODS.put("get", "GET");
        HTTP_METHODS.put("head", "HEAD");
        HTTP_METHODS.put("options", "OPTIONS");
        HTTP_METHODS.put("patch", "PATCH");
        HTTP_METHODS.put("post", "POST");
        HTTP_METHODS.put("put", "PUT");
        HTTP_METHODS.put("trace", "TRACE");
        apiKitRoutePathExtractorMemoizer = new FunctionMemoizer<String, String>(HttpSpanUtil::apiKitRoutePathExtractor);
    }
}

