/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor.util;

import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.Borrowable;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.PooledTraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.TraceComponentPool;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceComponentManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceComponentManager.class);
    private static final TraceComponentManager INSTANCE = new TraceComponentManager();
    private static final String MULE_OTEL_POOLING_TRACECOMPONENT_ENABLED = "mule.otel.pooling.tracecomponent.enabled";
    private final Map<String, Borrowable> activeComponents = new ConcurrentHashMap<String, Borrowable>();
    private static final long CLEANUP_INTERVAL_SECONDS = 120L;
    private static final long MAX_COMPONENT_AGE_MILLIS = 300000L;
    private final ScheduledExecutorService cleanupExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "TraceComponentManager-Cleanup");
        t.setDaemon(true);
        return t;
    });
    private final TraceComponentPool pool;
    private static volatile boolean usePooling = true;

    private static void init() {
        usePooling = PropertiesUtil.getBoolean(MULE_OTEL_POOLING_TRACECOMPONENT_ENABLED, true);
        LOGGER.trace("TraceComponent pooling is {}", (Object)(usePooling ? "enabled" : "disabled"));
    }

    public static void resetForTest() {
        INSTANCE.clear();
        TraceComponentManager.init();
    }

    private void clear() {
        this.pool.clear();
    }

    private TraceComponentManager() {
        this.cleanupExecutor.scheduleWithFixedDelay(this::cleanupStaleComponents, 120L, 120L, TimeUnit.SECONDS);
        this.pool = new TraceComponentPool(this::handleComponentClose);
    }

    public static TraceComponentManager getInstance() {
        return INSTANCE;
    }

    public TraceComponent createTraceComponent(String transactionId, String name) {
        TraceComponent component = usePooling ? this.pool.acquire(transactionId, name) : TraceComponent.of(name, new HashMap<String, String>(32)).withTransactionId(transactionId);
        this.trackComponent(component);
        return component;
    }

    public TraceComponent createTraceComponent(String transactionId, String name, ComponentLocation location) {
        TraceComponent component = usePooling ? this.pool.acquire(transactionId, name, location) : TraceComponent.of(name, new HashMap<String, String>(32)).withTransactionId(transactionId).withLocation(location.getLocation());
        this.trackComponent(component);
        return component;
    }

    public TraceComponent createTraceComponent(String transactionId, Component component) {
        ComponentLocation location = component.getLocation();
        return this.createTraceComponent(transactionId, location.getLocation(), location);
    }

    public TraceComponent createTraceComponent(String transactionId, ComponentLocation location) {
        return this.createTraceComponent(transactionId, location.getLocation(), location);
    }

    private void handleComponentClose(TraceComponent component) {
        if (component == null) {
            return;
        }
        String key = this.getComponentKey(component);
        if (key != null) {
            this.activeComponents.remove(key);
        }
        if (usePooling) {
            this.pool.release(component);
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Closed TraceComponent: {}", (Object)key);
        }
    }

    public void releaseComponent(TraceComponent component) {
        if (component == null) {
            return;
        }
        if (component instanceof PooledTraceComponent) {
            try {
                component.close();
            }
            catch (Exception e) {
                LOGGER.warn("Error closing PooledTraceComponent", (Throwable)e);
            }
        } else {
            String key = this.getComponentKey(component);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Released non-pooled TraceComponent: {}", (Object)key);
            }
        }
    }

    public void releaseComponent(String transactionId, String location) {
        String key = this.generateKey(transactionId, location);
        Borrowable borrowed = this.activeComponents.remove(key);
        if (borrowed != null) {
            this.releaseComponent((TraceComponent)((Object)borrowed));
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Released TraceComponent by key: {}", (Object)key);
            }
        }
    }

    private void trackComponent(TraceComponent component) {
        if (component == null || !usePooling) {
            return;
        }
        String key = this.getComponentKey(component);
        if (key != null && component instanceof Borrowable) {
            this.activeComponents.put(key, (Borrowable)((Object)component));
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Tracking TraceComponent: {}", (Object)key);
            }
        }
    }

    private String getComponentKey(TraceComponent component) {
        String transactionId = component.getTransactionId();
        String location = component.getLocation();
        if (transactionId == null && location == null) {
            return null;
        }
        return this.generateKey(transactionId, location);
    }

    private String generateKey(String transactionId, String location) {
        if (transactionId != null && location != null) {
            return transactionId + "|" + location;
        }
        if (transactionId != null) {
            return transactionId + "|";
        }
        return "|" + location;
    }

    private void cleanupStaleComponents() {
        long now = System.currentTimeMillis();
        int cleaned = 0;
        for (Map.Entry<String, Borrowable> entry : this.activeComponents.entrySet()) {
            Borrowable borrowed = entry.getValue();
            if (now - borrowed.getBorrowedAt() > 300000L) {
                if (!this.activeComponents.remove(entry.getKey(), borrowed)) continue;
                this.releaseComponent((TraceComponent)((Object)borrowed));
                ++cleaned;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Cleaned up stale TraceComponent: {}", (Object)entry.getKey());
                continue;
            }
            if (now - borrowed.getBorrowedAt() <= 60000L || !LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Stale TraceComponent still active Key: {}, component: {}", (Object)entry.getKey(), (Object)borrowed);
        }
        if (cleaned > 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cleaned up {} stale TraceComponents", (Object)cleaned);
        }
        if (LOGGER.isDebugEnabled()) {
            this.pool.logStatistics();
        }
    }

    public void logStatistics() {
        this.pool.logStatistics();
    }

    public int getActiveComponentCount() {
        return this.activeComponents.size();
    }

    public void shutdown() {
        this.cleanupExecutor.shutdown();
        try {
            if (!this.cleanupExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.cleanupExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.cleanupExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        for (Borrowable borrowed : this.activeComponents.values()) {
            this.releaseComponent((TraceComponent)((Object)borrowed));
        }
        this.activeComponents.clear();
    }

    static {
        TraceComponentManager.init();
    }
}

