/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor.util;

import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.PooledTraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceComponentPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceComponentPool.class);
    private static final String MULE_OTEL_POOLING_TRACECOMPONENT_MAXSIZE = "mule.otel.pooling.tracecomponent.maxsize";
    private static final int MAX_POOL_SIZE = PropertiesUtil.getInt("mule.otel.pooling.tracecomponent.maxsize", 1000);
    private final Queue<PooledTraceComponent> componentPool = new ConcurrentLinkedQueue<PooledTraceComponent>();
    private final AtomicLong componentsCreated = new AtomicLong(0L);
    private final AtomicLong componentsReused = new AtomicLong(0L);
    private final AtomicLong componentsReturned = new AtomicLong(0L);
    private final AtomicInteger currentPoolSize = new AtomicInteger(0);
    private final Consumer<TraceComponent> onClose;

    TraceComponentPool(Consumer<TraceComponent> onClose) {
        this.onClose = onClose;
        this.prewarmPool();
    }

    public TraceComponent acquire(String transactionId, String name) {
        PooledTraceComponent pooled = this.componentPool.poll();
        if (pooled != null) {
            this.currentPoolSize.decrementAndGet();
            this.componentsReused.incrementAndGet();
            pooled.reset(transactionId, name);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Reused TraceComponent from pool (pool size: {}) - {} - {}", new Object[]{this.currentPoolSize.get(), pooled.getId() + " - " + pooled.getName(), pooled});
            }
            return pooled.withBorrowedAt(System.currentTimeMillis());
        }
        this.componentsCreated.incrementAndGet();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Created new TraceComponent (total created: {})", (Object)this.componentsCreated.get());
        }
        TraceComponent traceComponent = new PooledTraceComponent(transactionId, name, this.onClose).withBorrowedAt(System.currentTimeMillis());
        return traceComponent;
    }

    public TraceComponent acquire(String transactionId, String name, ComponentLocation location) {
        TraceComponent component = this.acquire(transactionId, name).withLocation(location.getLocation()).withComponentLocation(location);
        return component;
    }

    public void release(TraceComponent component) {
        if (!(component instanceof PooledTraceComponent)) {
            return;
        }
        PooledTraceComponent pooled = (PooledTraceComponent)component;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Returning TraceComponent to pool (pool size: {}): {} - {}", new Object[]{this.currentPoolSize.get(), pooled.getId() + " - " + pooled.getName(), pooled});
        }
        pooled.clear();
        if (this.currentPoolSize.get() < MAX_POOL_SIZE) {
            this.componentPool.offer(pooled);
            this.currentPoolSize.incrementAndGet();
            this.componentsReturned.incrementAndGet();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Returned TraceComponent to pool (pool size: {}) - {}", (Object)this.currentPoolSize.get(), (Object)pooled);
            }
        }
    }

    private void prewarmPool() {
        int prewarmSize = Math.min(50, MAX_POOL_SIZE);
        for (int i = 0; i < prewarmSize; ++i) {
            PooledTraceComponent component = new PooledTraceComponent(null, null, this.onClose);
            this.componentPool.offer(component);
            this.currentPoolSize.incrementAndGet();
        }
        LOGGER.trace("Pre-warmed pool: {} components", (Object)prewarmSize);
    }

    public void clear() {
        this.componentPool.clear();
        this.currentPoolSize.set(0);
    }

    public void logStatistics() {
        long totalComponentOps = this.componentsCreated.get() + this.componentsReused.get();
        double componentReuseRate = totalComponentOps > 0L ? 100.0 * (double)this.componentsReused.get() / (double)totalComponentOps : 0.0;
        LOGGER.trace("TraceComponent Pool Stats: created={}, reused={}, returned={}, pool_size={}, reuse_rate={}", new Object[]{this.componentsCreated.get(), this.componentsReused.get(), this.componentsReturned.get(), this.currentPoolSize.get(), componentReuseRate});
    }
}

