/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionMeta;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ComponentRegistryService;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.TraceComponentManager;
import com.avioconsulting.mule.opentelemetry.internal.store.AbstractTransaction;
import com.avioconsulting.mule.opentelemetry.internal.store.ContainerSpan;
import com.avioconsulting.mule.opentelemetry.internal.store.ProcessorSpan;
import com.avioconsulting.mule.opentelemetry.internal.util.BatchHelperUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchTransaction
extends AbstractTransaction {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchTransaction.class);
    private final ConcurrentHashMap<String, AtomicReference<ContainerSpan>> stepSpans = new ConcurrentHashMap();
    private final Map<String, ProcessorSpan> stepProcessorSpans = new ConcurrentHashMap<String, ProcessorSpan>();
    private final Span rootSpan;
    private final Function<String, SpanBuilder> spanBuilderFunction;
    private final ComponentRegistryService componentRegistryService;
    private boolean rootSpanEnded = false;
    private final Map<String, String> batchTags = new HashMap<String, String>();
    private final Map<String, String> stepLocationNames = new HashMap<String, String>();
    private final Context rootContext;

    public BatchTransaction(String jobInstanceId, String traceId, String batchJobName, Span rootSpan, TraceComponent batchTraceComponent, Function<String, SpanBuilder> spanBuilderFunction, ComponentRegistryService componentRegistryService) {
        super(jobInstanceId, traceId, batchJobName, batchTraceComponent.getStartTime());
        batchTraceComponent.copyTagsTo(this.batchTags);
        this.rootSpan = rootSpan;
        this.rootContext = rootSpan.storeInContext(Context.current());
        this.spanBuilderFunction = spanBuilderFunction;
        this.componentRegistryService = componentRegistryService;
        OpenTelemetryUtil.tagsToAttributes(batchTraceComponent, rootSpan);
        this.extractStepLocations(batchTraceComponent);
        this.setTransactionContext();
    }

    private void extractStepLocations(TraceComponent batchTraceComponent) {
        String jobSteps = batchTraceComponent.getTag(SemanticAttributes.MULE_BATCH_JOB_STEPS.getKey());
        if (jobSteps != null) {
            StringTokenizer tokenizer = new StringTokenizer(jobSteps, ",");
            while (tokenizer.hasMoreTokens()) {
                String step = tokenizer.nextToken().trim();
                if (step.isEmpty()) continue;
                String stepName = step.substring(0, step.indexOf("|"));
                String stepLocation = step.substring(step.indexOf("|") + 1);
                this.stepLocationNames.put(stepLocation, stepName);
            }
        }
    }

    private ContainerSpan addOrGetContainerSpan(String location, String stepName, TraceComponent processorTrace) {
        AtomicReference containerSpanRef = this.stepSpans.computeIfAbsent(location, s -> new AtomicReference());
        String name = "batch:step";
        String spanName = stepName;
        if (ComponentsUtil.isBatchOnComplete(location, this.componentRegistryService)) {
            name = "batch:on-complete";
            spanName = "batch:on-complete";
        } else {
            name = "batch:step:" + stepName;
        }
        ContainerSpan ContainerSpan2 = (ContainerSpan)containerSpanRef.get();
        if (ContainerSpan2 == null) {
            try (TraceComponent stepTraceComponent = TraceComponentManager.getInstance().createTraceComponent(processorTrace.getTransactionId(), name);){
                SpanBuilder spanBuilder;
                ContainerSpan newContainerSpan;
                stepTraceComponent.withSpanName(spanName).withSpanKind(SpanKind.INTERNAL).withLocation(location).withEventContextId(processorTrace.getEventContextId()).withStartTime(processorTrace.getStartTime());
                processorTrace.copyTagsTo(stepTraceComponent, key -> key.startsWith("mule.app.processor"));
                if (stepName != null) {
                    stepTraceComponent.addTag(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey(), stepName);
                }
                if (containerSpanRef.compareAndSet(null, newContainerSpan = new ContainerSpan(location, (spanBuilder = this.spanBuilderFunction.apply(name).setParent(this.rootContext)).startSpan(), stepTraceComponent))) {
                    this.stepProcessorSpans.putIfAbsent(stepTraceComponent.getSpanName(), newContainerSpan.getRootProcessorSpan());
                    ContainerSpan2 = newContainerSpan;
                }
            }
        }
        return ContainerSpan2;
    }

    @Override
    public SpanMeta addProcessorSpan(String containerPath, TraceComponent traceComponent, SpanBuilder spanBuilder) {
        SpanMeta spanMeta = null;
        String stepName = traceComponent.getTag(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey());
        if (ComponentsUtil.isBatchOnComplete(containerPath, this.componentRegistryService)) {
            stepName = "batch:on-complete";
        }
        ProcessorSpan containerProcessorSpan = this.getStepProcessorSpan(traceComponent, stepName);
        ContainerSpan ContainerSpan2 = null;
        if (containerProcessorSpan == null) {
            ContainerSpan2 = this.addOrGetContainerSpan(containerPath, this.stepLocationNames.get(containerPath), traceComponent);
            containerProcessorSpan = this.getStepProcessorSpan(traceComponent, stepName);
        } else {
            ContainerSpan2 = this.stepSpans.get(containerProcessorSpan.getLocation()).get();
        }
        if (containerProcessorSpan.getLocation().equalsIgnoreCase(containerPath)) {
            spanMeta = this.processContainerChild(containerPath, traceComponent, spanBuilder, ContainerSpan2, containerProcessorSpan);
        } else {
            SpanMeta aggrSpan = this.addAggregatorSpanIfNeeded(containerPath, traceComponent, ContainerSpan2, containerProcessorSpan);
            if (aggrSpan != null) {
                traceComponent.withContext(aggrSpan.getContext());
            }
            spanMeta = ContainerSpan2.addProcessorSpan(containerPath, traceComponent, spanBuilder);
        }
        return spanMeta;
    }

    private SpanMeta addAggregatorSpanIfNeeded(String containerPath, TraceComponent traceComponent, ContainerSpan ContainerSpan2, ProcessorSpan containerProcessorSpan) {
        SpanMeta aggrSpan = null;
        if (containerPath.endsWith("/aggregator") && null == ContainerSpan2.findSpan(traceComponent.contextScopedPath(containerPath))) {
            SpanBuilder aggrSpanBuilder = this.spanBuilderFunction.apply("batch:aggregator").setParent(containerProcessorSpan.getContext()).setSpanKind(SpanKind.INTERNAL).setStartTimestamp(traceComponent.getStartTime());
            try (TraceComponent aggrTraceComponent = TraceComponentManager.getInstance().createTraceComponent(traceComponent.getTransactionId(), "batch:aggregator");){
                aggrTraceComponent.withLocation(containerPath).withSpanName("batch:aggregator").withContext(containerProcessorSpan.getContext()).withSpanKind(SpanKind.INTERNAL).withStartTime(traceComponent.getStartTime()).withEventContextId(traceComponent.getEventContextId()).withSiblings(traceComponent.getSiblings());
                BatchHelperUtil.copyBatchTags(traceComponent, aggrTraceComponent);
                aggrTraceComponent.addTag(SemanticAttributes.MULE_APP_PROCESSOR_NAMESPACE.getKey(), "batch");
                aggrTraceComponent.addTag(SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey(), "aggregator");
                aggrSpan = ContainerSpan2.addProcessorSpan(containerPath.substring(0, containerPath.lastIndexOf("/")), aggrTraceComponent, aggrSpanBuilder);
            }
        }
        return aggrSpan;
    }

    private SpanMeta processContainerChild(String containerPath, TraceComponent traceComponent, SpanBuilder spanBuilder, ContainerSpan stepSpan, ProcessorSpan processorSpan) {
        SpanMeta spanMeta;
        if (ComponentsUtil.isBatchOnComplete(containerPath, this.componentRegistryService)) {
            spanMeta = stepSpan.addProcessorSpan(containerPath, traceComponent, spanBuilder);
        } else {
            String recordPath = containerPath + "/record";
            if (traceComponent.getLocation().equalsIgnoreCase(containerPath + "/processors/0")) {
                try (TraceComponent recordTrace = TraceComponentManager.getInstance().createTraceComponent(traceComponent.getTransactionId(), "batch:step-record");){
                    recordTrace.withLocation(recordPath).withStartTime(traceComponent.getStartTime()).withSpanName("batch:step-record").withEventContextId(traceComponent.getEventContextId());
                    traceComponent.copyTagsTo(recordTrace);
                    SpanBuilder record = this.spanBuilderFunction.apply(recordTrace.getName());
                    SpanMeta recordSpanMeta = stepSpan.addChildContainer(recordTrace, record.setParent(processorSpan.getContext()));
                    spanMeta = stepSpan.addProcessorSpan(recordTrace.getLocation(), traceComponent, spanBuilder.setParent(recordSpanMeta.getContext()));
                }
            } else {
                spanMeta = stepSpan.addProcessorSpan(recordPath, traceComponent, spanBuilder);
            }
        }
        return spanMeta;
    }

    private ProcessorSpan getStepProcessorSpan(TraceComponent traceComponent, String containerName) {
        if (containerName == null) {
            return null;
        }
        ProcessorSpan processorSpan = this.stepProcessorSpans.get(containerName);
        if (processorSpan != null) {
            traceComponent.copyTagsTo(processorSpan.getTags());
        }
        return processorSpan;
    }

    private ProcessorSpan getStepProcessorSpan(TraceComponent traceComponent) {
        String containerName = traceComponent.getTag(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey());
        return this.getStepProcessorSpan(traceComponent, containerName);
    }

    @Override
    public SpanMeta endProcessorSpan(TraceComponent traceComponent, Consumer<Span> spanUpdater, Instant endTime) {
        String locationParent;
        if ("batch:step".equalsIgnoreCase(traceComponent.getName()) || "batch:on-complete".equalsIgnoreCase(traceComponent.getName())) {
            return this.endContainerSpan(traceComponent, this.stepProcessorSpans.get(traceComponent.getSpanName()));
        }
        String spanName = traceComponent.getTag(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey());
        if (spanName == null && ComponentsUtil.isBatchOnComplete(locationParent = ComponentsUtil.getLocationParent(traceComponent.getLocation()), this.componentRegistryService)) {
            spanName = "batch:on-complete";
        }
        if (spanName != null) {
            ProcessorSpan aggrSpan;
            String stepLocation = this.stepProcessorSpans.get(spanName).getLocation();
            ContainerSpan ContainerSpan2 = this.stepSpans.get(stepLocation).get();
            SpanMeta spanMeta = ContainerSpan2.endProcessorSpan(traceComponent, spanUpdater, endTime);
            String aggregatorLocation = stepLocation + "/aggregator";
            if (traceComponent.getLocation() != null && traceComponent.getLocation().startsWith(aggregatorLocation) && (aggrSpan = ContainerSpan2.findSpan(traceComponent.contextScopedPath(aggregatorLocation))).getSiblings() == 0L) {
                try (TraceComponent aggrTraceComponent = TraceComponentManager.getInstance().createTraceComponent(traceComponent.getTransactionId(), "batch:aggregator");){
                    aggrTraceComponent.withLocation(aggregatorLocation).withSpanName("batch:aggregator").withSpanKind(SpanKind.INTERNAL).withEventContextId(traceComponent.getEventContextId()).withEndTime(traceComponent.getEndTime());
                    traceComponent.copyTagsTo(aggrTraceComponent);
                    ContainerSpan2.endProcessorSpan(aggrTraceComponent, spanUpdater, endTime);
                }
            }
            return spanMeta;
        }
        return null;
    }

    private ProcessorSpan endContainerSpan(TraceComponent traceComponent, ProcessorSpan processorSpan) {
        if (processorSpan == null) {
            return null;
        }
        ContainerSpan stepSpan = this.stepSpans.get(processorSpan.getLocation()).get();
        processorSpan.setEndTime(traceComponent.getEndTime());
        traceComponent.copyTagsTo(processorSpan.getTags());
        stepSpan.getSpan().end(traceComponent.getEndTime());
        return processorSpan;
    }

    @Override
    public Span getTransactionSpan() {
        return this.rootSpan;
    }

    @Override
    public void endRootSpan(TraceComponent traceComponent, Consumer<Span> endSpan) {
        this.stepProcessorSpans.forEach((location, processorSpan) -> this.endContainerSpan(traceComponent, (ProcessorSpan)processorSpan));
        super.endRootSpan(traceComponent, endSpan);
        this.rootSpanEnded = true;
    }

    @Override
    public boolean hasEnded() {
        return this.rootSpanEnded;
    }

    @Override
    public void addChildTransaction(TraceComponent traceComponent, SpanBuilder spanBuilder) {
        ProcessorSpan processorSpan = this.getStepProcessorSpan(traceComponent);
        ContainerSpan stepSpan = this.stepSpans.get(processorSpan.getLocation()).get();
        stepSpan.addChildContainer(traceComponent, spanBuilder);
    }

    @Override
    public TransactionMeta endChildTransaction(TraceComponent traceComponent, Consumer<Span> endSpan) {
        ProcessorSpan processorSpan = this.getStepProcessorSpan(traceComponent);
        ContainerSpan stepSpan = this.stepSpans.get(processorSpan.getLocation()).get();
        return stepSpan.endChildContainer(traceComponent, endSpan);
    }

    @Override
    public ProcessorSpan findSpan(String location) {
        ProcessorSpan processorSpan = null;
        for (Map.Entry<String, AtomicReference<ContainerSpan>> entry : this.stepSpans.entrySet()) {
            processorSpan = entry.getValue().get().findSpan(location);
            if (processorSpan == null) continue;
            return processorSpan;
        }
        return null;
    }

    @Override
    public Span getSpan() {
        return this.rootSpan;
    }

    @Override
    public Map<String, String> getTags() {
        return this.batchTags;
    }
}

