/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.util;

import com.avioconsulting.mule.opentelemetry.api.ee.batch.BatchJob;
import com.avioconsulting.mule.opentelemetry.api.ee.batch.BatchStep;
import com.avioconsulting.mule.opentelemetry.api.ee.batch.BatchUtil;
import com.avioconsulting.mule.opentelemetry.api.ee.batch.Record;
import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ComponentRegistryService;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import java.util.List;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;

public class BatchHelperUtil {
    private static BatchUtil batchUtilDelegate;
    private static boolean batchSupportDisabled;

    public static void _resetForTesting() {
        batchSupportDisabled = true;
        batchUtilDelegate = null;
    }

    public static void init(BatchUtil batchUtil) {
        batchUtilDelegate = batchUtil;
    }

    private static BatchUtil getBatchUtil() {
        return batchUtilDelegate;
    }

    public static BatchStep toBatchStep(Component component) {
        return BatchHelperUtil.isBatchSupportDisabled() ? null : BatchHelperUtil.getBatchUtil().toBatchStep(component);
    }

    public static BatchJob toBatchJob(Component component) {
        return BatchHelperUtil.isBatchSupportDisabled() ? null : BatchHelperUtil.getBatchUtil().toBatchJob(component);
    }

    public static boolean isBatchStep(String location, ComponentRegistryService componentRegistryService) {
        Component component = componentRegistryService.findComponentByLocation(location);
        return component != null && batchUtilDelegate.isBatchStep(component);
    }

    public static boolean notBatchChildContainer(String containerName, ComponentRegistryService componentRegistryService) {
        return BatchHelperUtil.isBatchStep(containerName, componentRegistryService) || ComponentsUtil.isBatchOnComplete(containerName, componentRegistryService);
    }

    public static boolean hasBatchJobInstanceId(TraceComponent traceComponent) {
        return traceComponent.hasTagFor(SemanticAttributes.MULE_BATCH_JOB_INSTANCE_ID.getKey());
    }

    public static String getBatchJobInstanceId(TraceComponent traceComponent) {
        return traceComponent.getTag(SemanticAttributes.MULE_BATCH_JOB_INSTANCE_ID.getKey());
    }

    public static String getBatchJobInstanceId(Event event) {
        TypedValue batchJobInstanceId = null;
        batchJobInstanceId = (TypedValue)event.getVariables().get("batchJobInstanceId");
        if (batchJobInstanceId != null && batchJobInstanceId.getValue() != null) {
            return batchJobInstanceId.getValue().toString();
        }
        return null;
    }

    public static boolean isBatchStepFirstProcessor(ComponentLocation location, Event event, ComponentRegistryService componentRegistryService) {
        if (BatchHelperUtil.isBatchSupportDisabled()) {
            return false;
        }
        return BatchHelperUtil.isBatchStep(ComponentsUtil.getLocationParent(location.getLocation()), componentRegistryService) && ComponentsUtil.isFirstProcessorInScope(location);
    }

    public static boolean hasBatchStep(TraceComponent traceComponent) {
        return traceComponent.hasTagFor(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey());
    }

    public static void addBatchTags(TraceComponent traceComponent, Event event) {
        String batchJobId = BatchHelperUtil.getBatchJobInstanceId(event);
        if (!BatchHelperUtil.isBatchSupportDisabled() && batchJobId != null) {
            List records;
            traceComponent.addTag(SemanticAttributes.MULE_BATCH_JOB_INSTANCE_ID.getKey(), batchJobId);
            if (event.getVariables().containsKey("_mule_batch_INTERNAL_record") && event.getVariables().get("_mule_batch_INTERNAL_record") != null && ((TypedValue)event.getVariables().get("_mule_batch_INTERNAL_record")).getValue() != null) {
                Record record = BatchHelperUtil.getBatchUtil().toRecord(((TypedValue)event.getVariables().get("_mule_batch_INTERNAL_record")).getValue());
                traceComponent.addTag(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey(), record.getCurrentStepId());
            } else if (event.getVariables().containsKey("records") && event.getVariables().get("records") != null && ((TypedValue)event.getVariables().get("records")).getValue() != null && !(records = (List)((TypedValue)event.getVariables().get("records")).getValue()).isEmpty()) {
                Record record = BatchHelperUtil.getBatchUtil().toRecord(records.get(0));
                traceComponent.addTag(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey(), record.getCurrentStepId());
                traceComponent.addTag(SemanticAttributes.MULE_BATCH_JOB_STEP_AGGREGATOR_RECORD_COUNT.getKey(), String.valueOf(records.size()));
            }
        }
    }

    public static void copyBatchTags(TraceComponent source, TraceComponent target) {
        if (!BatchHelperUtil.isBatchSupportDisabled()) {
            source.copyTagsTo(target, key -> key.startsWith("mule.batch.job"));
        }
    }

    public static void enableBatchSupport() {
        batchSupportDisabled = false;
    }

    public static boolean isBatchSupportDisabled() {
        return batchSupportDisabled;
    }

    public static boolean shouldSkipThisBatchProcessing(Event event) {
        return event != null && BatchHelperUtil.isBatchSupportDisabled() && OpenTelemetryUtil.getEventTransactionId(event).equalsIgnoreCase(BatchHelperUtil.getBatchJobInstanceId(event));
    }

    static {
        batchSupportDisabled = true;
    }
}

