/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.util;

import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk.AttributesKeyCache;
import com.avioconsulting.mule.opentelemetry.internal.util.BatchHelperUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetryUtil.class);
    private static final AttributesKeyCache attributesKeyCache = new AttributesKeyCache();

    public static Map<String, String> getGlobalConfigSystemAttributes(String configName, Map<String, String> sourceMap) {
        if (configName == null || configName.trim().isEmpty() || sourceMap == null || sourceMap.isEmpty()) {
            return Collections.emptyMap();
        }
        String configRef = configName.toLowerCase();
        String replaceVal = configRef + ".otel.";
        HashMap<String, String> newTags = new HashMap<String, String>();
        for (Map.Entry<String, String> e : sourceMap.entrySet()) {
            if (!e.getKey().startsWith(configRef)) continue;
            String propKey = e.getKey().substring(replaceVal.length());
            newTags.put(propKey, e.getValue());
        }
        return newTags;
    }

    public static String getEventTransactionId(Event event) {
        String transactionId = null;
        if (event.getVariables().containsKey("_OTEL_BATCH_PARENT_CONTEXT_ID") || (transactionId = BatchHelperUtil.getBatchJobInstanceId(event)) == null) {
            transactionId = OpenTelemetryUtil.getEventTransactionId(event.getContext().getId());
        }
        return transactionId;
    }

    public static String getEventTransactionId(String eventId) {
        int index = eventId.indexOf(95);
        return index != -1 ? eventId.substring(0, index) : eventId;
    }

    public static void addAttribute(String property, AttributesBuilder builder, AttributeKey<String> attributeKey) {
        String value = PropertiesUtil.getProperty(property);
        if (value != null) {
            builder.put(attributeKey, (Object)value);
        }
    }

    public static void resolveExpressions(TraceComponent traceComponent, ExpressionManager expressionManager, Event event) {
        try {
            String value;
            if (expressionManager.isExpression(traceComponent.getSpanName()) && (value = OpenTelemetryUtil.resolveExpression(traceComponent.getSpanName(), expressionManager, event)) != null) {
                traceComponent.withSpanName(value);
            }
            traceComponent.forEachTagEntry(entry -> {
                if (expressionManager.isExpression((String)entry.getValue())) {
                    try {
                        entry.setValue(OpenTelemetryUtil.resolveExpression((String)entry.getValue(), expressionManager, event));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String resolveExpression(String expression, ExpressionManager expressionManager, Event event) throws Exception {
        TypedValue evaluate = expressionManager.evaluate(expression, DataType.STRING, event.asBindingContext());
        return OpenTelemetryUtil.typedValueToString(evaluate);
    }

    public static String typedValueToString(TypedValue typedValue) throws Exception {
        String value = "";
        Object input = typedValue.getValue();
        value = input instanceof CursorStreamProvider ? IOUtils.toString((InputStream)((InputStream)((CursorStreamProvider)input).openCursor())) : (input instanceof InputStream ? IOUtils.toString((InputStream)((InputStream)input)) : TypedValue.unwrap((Object)typedValue).toString());
        return value;
    }

    public static void tagsToAttributes(TraceComponent traceComponent, SpanBuilder spanBuilder) {
        if (!traceComponent.hasTags()) {
            return;
        }
        traceComponent.forEachTagEntry(entry -> {
            AttributeKey<?> attributeKey = attributesKeyCache.getAttributeKey((String)entry.getKey());
            spanBuilder.setAttribute(attributeKey, attributesKeyCache.convertValue(attributeKey, (String)entry.getValue()));
        });
    }

    public static void tagsToAttributes(TraceComponent traceComponent, Span span) {
        if (!traceComponent.hasTags()) {
            return;
        }
        traceComponent.forEachTagEntry(entry -> {
            AttributeKey<?> attributeKey = attributesKeyCache.getAttributeKey((String)entry.getKey());
            span.setAttribute(attributeKey, attributesKeyCache.convertValue(attributeKey, (String)entry.getValue()));
        });
    }
}

