/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.connection;

import com.avioconsulting.mule.opentelemetry.api.AppIdentifier;
import com.avioconsulting.mule.opentelemetry.api.providers.OpenTelemetryMetricsConfigProvider;
import com.avioconsulting.mule.opentelemetry.api.providers.OpenTelemetryMetricsProvider;
import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionStore;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.api.traces.TransactionContext;
import com.avioconsulting.mule.opentelemetry.internal.config.OpenTelemetryConfigWrapper;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryMetricsProviderCollection;
import com.avioconsulting.mule.opentelemetry.internal.connection.TraceContextHandler;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ComponentRegistryService;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.TraceComponentManager;
import com.avioconsulting.mule.opentelemetry.internal.store.InMemoryTransactionStore;
import com.avioconsulting.mule.opentelemetry.internal.store.TransactionProcessor;
import com.avioconsulting.mule.opentelemetry.internal.util.BatchHelperUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.ServiceProviderUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.memoizers.BiFunctionMemoizer;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.semconv.ErrorAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryConnection
implements TraceContextHandler,
TransactionProcessor {
    private final OpenTelemetryMetricsProviderCollection metricsProviders = ServiceProviderUtil.load(OpenTelemetryMetricsProvider.class.getClassLoader(), OpenTelemetryMetricsProvider.class, new OpenTelemetryMetricsProviderCollection());
    private final Logger logger = LoggerFactory.getLogger(OpenTelemetryConnection.class);
    private OpenTelemetryMetricsConfigProvider metricsProvider;
    private AppIdentifier appIdentifier;
    private ExpressionManager expressionManager;
    private static final String INSTRUMENTATION_VERSION = "0.0.1-DEV";
    private static final String INSTRUMENTATION_NAME = "mule-opentelemetry-module-DEV";
    private final TransactionStore transactionStore;
    private OpenTelemetry openTelemetry;
    private final Tracer tracer;
    private boolean turnOffTracing = false;
    private boolean turnOffMetrics = false;
    private ComponentRegistryService componentRegistryService;
    private final BiFunctionMemoizer<String, TraceComponent, String> parentLocationMemoizer = BiFunctionMemoizer.memoize((key, traceComponent) -> ComponentsUtil.getRouteContainerLocation(traceComponent), true);

    private OpenTelemetryConnection(OpenTelemetryConfigWrapper openTelemetryConfigWrapper) {
        Properties properties = OpenTelemetryConnection.getModuleProperties();
        String instrumentationVersion = properties.getProperty("module.version", INSTRUMENTATION_VERSION);
        String instrumentationName = properties.getProperty("module.artifactId", INSTRUMENTATION_NAME);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initialising OpenTelemetry Mule 4 Agent for instrumentation {}:{}", (Object)instrumentationName, (Object)instrumentationVersion);
        }
        AutoConfiguredOpenTelemetrySdkBuilder builder = AutoConfiguredOpenTelemetrySdk.builder();
        if (openTelemetryConfigWrapper != null) {
            HashMap<String, String> configMap = new HashMap<String, String>();
            if (openTelemetryConfigWrapper.getResource() != null) {
                configMap.putAll(openTelemetryConfigWrapper.getResource().getConfigMap());
            }
            if (openTelemetryConfigWrapper.getExporter() != null) {
                configMap.putAll(openTelemetryConfigWrapper.getExporter().getExporterProperties());
            }
            if (openTelemetryConfigWrapper.getSpanProcessorConfiguration() != null) {
                configMap.putAll(openTelemetryConfigWrapper.getSpanProcessorConfiguration().getConfigMap());
            }
            configMap.put("otel.java.disabled.resource.providers", "io.opentelemetry.instrumentation.resources.HostResourceProvider,io.opentelemetry.instrumentation.resources.ContainerResourceProvider,io.opentelemetry.instrumentation.resources.ProcessResourceProvider");
            this.configureLogParameters(configMap);
            builder.addPropertiesSupplier(() -> Collections.unmodifiableMap(configMap));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating OpenTelemetryConnection with properties: [{}]", configMap);
            }
            this.turnOffTracing = openTelemetryConfigWrapper.isTurnOffTracing();
            this.turnOffMetrics = openTelemetryConfigWrapper.isTurnOffMetrics();
            this.appIdentifier = openTelemetryConfigWrapper.getOpenTelemetryConfiguration().getAppIdentifier();
            this.metricsProvider = openTelemetryConfigWrapper.getOpenTelemetryConfiguration().getMetricsConfigProvider();
            this.expressionManager = openTelemetryConfigWrapper.getOpenTelemetryConfiguration().getExpressionManager();
        }
        builder.setServiceClassLoader(AutoConfiguredOpenTelemetrySdkBuilder.class.getClassLoader());
        if (this.metricsProvider != null) {
            this.metricsProvider.initialise(this.appIdentifier);
            this.metricsProvider.turnOffMetrics(this.turnOffMetrics);
        }
        this.openTelemetry = builder.build().getOpenTelemetrySdk();
        this.installOpenTelemetryLogger();
        if (this.metricsProvider != null) {
            if (!this.turnOffMetrics && this.logger.isInfoEnabled()) {
                this.logger.info("Initializing Metrics Providers");
            }
            this.metricsProvider.start();
            this.metricsProviders.initialize(this.metricsProvider, this.openTelemetry);
        }
        this.tracer = this.openTelemetry.getTracer(instrumentationName, instrumentationVersion);
        this.transactionStore = InMemoryTransactionStore.getInstance(this);
        PropertiesUtil.init();
    }

    public OpenTelemetryConnection setComponentRegistryService(ComponentRegistryService componentRegistryService) {
        this.componentRegistryService = componentRegistryService;
        return this;
    }

    @Override
    public ComponentRegistryService getComponentRegistryService() {
        return this.componentRegistryService;
    }

    public void withOpenTelemetry(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    private void configureLogParameters(Map<String, String> configMap) {
        configMap.put("otel.blrp.max.queue.size", "4096");
        configMap.put("otel.blrp.max.export.batch.size", "2048");
        configMap.put("otel.blrp.schedule.delay", "2000");
        configMap.put("otel.blrp.export.timeout", "15000");
    }

    private void installOpenTelemetryLogger() {
        try {
            Class<?> clazz = Class.forName("com.avioconsulting.mule.opentelemetry.logs.api.OpenTelemetryLog4jAppender");
            Method install = clazz.getMethod("install", OpenTelemetry.class);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Initializing AVIO OpenTelemetry Log4J support");
            }
            install.invoke(null, this.openTelemetry);
        }
        catch (ClassNotFoundException e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("OpenTelemetry Log4j support not found on the classpath. Logs will not be exported via OpenTelemetry.");
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public AppIdentifier getAppIdentifier() {
        return this.appIdentifier;
    }

    public boolean isTurnOffTracing() {
        return this.turnOffTracing;
    }

    public boolean isTurnOffMetrics() {
        return this.turnOffMetrics;
    }

    public OpenTelemetryMetricsProviderCollection getMetricsProviders() {
        return this.metricsProviders;
    }

    public static void _resetForTest() {
        InMemoryTransactionStore._resetForTesting();
    }

    public static synchronized OpenTelemetryConnection getInstance(OpenTelemetryConfigWrapper openTelemetryConfigWrapper) {
        return new OpenTelemetryConnection(openTelemetryConfigWrapper);
    }

    private static Properties getModuleProperties() {
        Properties moduleProperties = new Properties();
        try {
            InputStream resourceAsStream = OpenTelemetryConnection.class.getClassLoader().getResourceAsStream("mule-opentelemetry-module.properties");
            if (resourceAsStream != null) {
                moduleProperties.load(resourceAsStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return moduleProperties;
    }

    @Override
    public SpanBuilder spanBuilder(String spanName) {
        return this.tracer.spanBuilder(spanName);
    }

    @Override
    public <T> Context getTraceContext(T carrier, TextMapGetter<T> textMapGetter) {
        return this.openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), carrier, textMapGetter);
    }

    public Map<String, Object> getTraceContext(String transactionId) {
        return this.getTraceContext(transactionId, (String)null);
    }

    public Map<String, Object> getTraceContext(String transactionId, String componentLocation) {
        TransactionContext transactionContext = this.getTransactionStore().getTransactionContext(transactionId, componentLocation);
        Map<String, Object> traceContext = transactionContext.getTraceContextMap();
        this.injectTraceContext(transactionContext.getContext(), traceContext, HashMapObjectMapSetter.INSTANCE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Created trace context '{}' for TRACE_TRANSACTION_ID={}, Component Location '{}'", new Object[]{traceContext, transactionId, componentLocation});
        }
        return traceContext;
    }

    @Override
    public <T> void injectTraceContext(T carrier, TextMapSetter<T> textMapSetter) {
        this.openTelemetry.getPropagators().getTextMapPropagator().inject(Context.current(), carrier, textMapSetter);
    }

    private <T> void injectTraceContext(Context context, T carrier, TextMapSetter<T> textMapSetter) {
        this.openTelemetry.getPropagators().getTextMapPropagator().inject(context, carrier, textMapSetter);
    }

    public TransactionStore getTransactionStore() {
        return this.transactionStore;
    }

    public void invalidate() {
    }

    public Meter get(String instrumentationScopeName) {
        return this.openTelemetry.meterBuilder(instrumentationScopeName).build();
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    @Override
    public void addProcessorSpan(TraceComponent traceComponent, String containerName) {
        SpanBuilder spanBuilder = this.spanBuilder(traceComponent.getSpanName()).setSpanKind(traceComponent.getSpanKind()).setStartTimestamp(traceComponent.getStartTime());
        OpenTelemetryUtil.tagsToAttributes(traceComponent, spanBuilder);
        String parentLocation = null;
        if (!(BatchHelperUtil.hasBatchJobInstanceId(traceComponent) && BatchHelperUtil.notBatchChildContainer(containerName, this.componentRegistryService) || (parentLocation = this.parentLocationMemoizer.apply(traceComponent.getLocation(), traceComponent)) == null)) {
            SpanMeta parentSpan;
            try (TraceComponent parentTrace = TraceComponentManager.getInstance().createTraceComponent(traceComponent.getTransactionId(), parentLocation);){
                parentTrace.withLocation(parentLocation).withSpanName(parentLocation).withSpanKind(SpanKind.INTERNAL).withEventContextId(traceComponent.getEventContextId()).withStartTime(traceComponent.getStartTime());
                BatchHelperUtil.copyBatchTags(traceComponent, parentTrace);
                parentSpan = this.addRouteSpan(parentTrace, traceComponent, parentLocation, ComponentsUtil.getLocationParent(parentLocation));
            }
            spanBuilder.setParent(parentSpan.getContext());
        }
        if (parentLocation == null) {
            parentLocation = containerName;
        }
        this.getTransactionStore().addProcessorSpan(parentLocation, traceComponent, spanBuilder);
    }

    private SpanMeta addRouteSpan(TraceComponent parentTrace, TraceComponent childTrace, String parentLocation, String rootContainerName) {
        SpanBuilder spanBuilder = this.spanBuilder(parentLocation).setParent(childTrace.getContext()).setSpanKind(SpanKind.INTERNAL).setStartTimestamp(childTrace.getStartTime());
        return this.getTransactionStore().addProcessorSpan(rootContainerName, parentTrace, spanBuilder);
    }

    @Override
    public SpanMeta endProcessorSpan(TraceComponent traceComponent, Error error) {
        SpanMeta spanMeta = this.getTransactionStore().endProcessorSpan(traceComponent.getTransactionId(), traceComponent, span -> {
            if (error != null) {
                span.recordException(error.getCause());
                traceComponent.addTag(SemanticAttributes.ERROR_TYPE.getKey(), error.getCause().getClass().getCanonicalName());
                traceComponent.addTag(SemanticAttributes.ERROR_MESSAGE.getKey(), error.getDescription());
                if (error.getErrorType() != null && !"MULE:ANY".equals(error.getErrorType().toString())) {
                    traceComponent.addTag(ErrorAttributes.ERROR_TYPE.getKey(), error.getErrorType().toString());
                }
            }
            this.setSpanStatus(traceComponent, (Span)span);
            OpenTelemetryUtil.tagsToAttributes(traceComponent, span);
        }, traceComponent.getEndTime());
        this.processBatchJob(spanMeta, traceComponent);
        return spanMeta;
    }

    private void processBatchJob(SpanMeta spanMeta, TraceComponent traceComponent) {
        if (!traceComponent.getName().equalsIgnoreCase("batch:job")) {
            return;
        }
        String batchJobInstanceId = traceComponent.getTag(SemanticAttributes.MULE_BATCH_JOB_INSTANCE_ID.getKey());
        try (TraceComponent batchComponent = TraceComponentManager.getInstance().createTraceComponent(batchJobInstanceId, traceComponent.getTag(SemanticAttributes.MULE_BATCH_JOB_NAME.getKey()), traceComponent.getComponentLocation());){
            batchComponent.withLocation(traceComponent.getLocation()).withTransactionId(batchJobInstanceId).withSpanName(traceComponent.getTag(SemanticAttributes.MULE_BATCH_JOB_NAME.getKey())).withSpanKind(SpanKind.SERVER).withContext(spanMeta.getContext()).withEventContextId(traceComponent.getEventContextId()).withStartTime(traceComponent.getStartTime());
            batchComponent.addAllTags(spanMeta.getTags());
            traceComponent.copyTagsTo(batchComponent);
            this.startTransaction(batchComponent);
            if (BatchHelperUtil.isBatchSupportDisabled()) {
                batchComponent.addTag(SemanticAttributes.MULE_BATCH_TRACE_DISABLED.getKey(), "true");
                batchComponent.withEndTime(traceComponent.getEndTime());
                this.endTransaction(batchComponent, null);
            }
        }
    }

    @Override
    public void startTransaction(TraceComponent traceComponent) {
        SpanBuilder spanBuilder = this.spanBuilder(traceComponent.getSpanName()).setSpanKind(traceComponent.getSpanKind()).setParent(traceComponent.getContext()).setStartTimestamp(traceComponent.getStartTime());
        String configName = traceComponent.getTag(SemanticAttributes.MULE_APP_FLOW_SOURCE_CONFIG_REF.getKey());
        if (configName != null) {
            traceComponent.addAllTags(this.componentRegistryService.getGlobalConfigOtelSystemProperties(configName));
        }
        this.getTransactionStore().startTransaction(traceComponent, traceComponent.getName(), spanBuilder);
    }

    @Override
    public TransactionMeta endTransaction(TraceComponent traceComponent, Exception exception) {
        if (traceComponent == null) {
            return null;
        }
        return this.getTransactionStore().endTransaction(traceComponent, (Span rootSpan) -> {
            OpenTelemetryUtil.tagsToAttributes(traceComponent, rootSpan);
            this.setSpanStatus(traceComponent, (Span)rootSpan);
            if (exception != null) {
                MuleException muleException;
                rootSpan.recordException((Throwable)exception);
                rootSpan.setAttribute(SemanticAttributes.ERROR_TYPE, (Object)exception.getClass().getCanonicalName());
                rootSpan.setAttribute(SemanticAttributes.ERROR_MESSAGE, (Object)exception.getMessage());
                if (exception instanceof MuleException && (muleException = (MuleException)exception).getExceptionInfo() != null && muleException.getExceptionInfo().getErrorType() != null && !"MULE:ANY".equals(muleException.getExceptionInfo().getErrorType().toString())) {
                    rootSpan.setAttribute(SemanticAttributes.ERROR_TYPE, (Object)muleException.getExceptionInfo().getErrorType().toString());
                }
            }
        });
    }

    public void setSpanStatus(TraceComponent traceComponent, Span span) {
        if (traceComponent.getStatusCode() != null && !StatusCode.UNSET.equals((Object)traceComponent.getStatusCode())) {
            span.setStatus(traceComponent.getStatusCode(), traceComponent.getErrorMessage());
        }
    }

    public static enum HashMapObjectMapSetter implements TextMapSetter<Map<String, Object>>
    {
        INSTANCE;


        public void set(@Nullable Map<String, Object> carrier, String key, String value) {
            if (carrier != null) {
                carrier.put(key, value);
            }
        }
    }

    public static enum HashMapTextMapSetter implements TextMapSetter<Map<String, String>>
    {
        INSTANCE;


        public void set(@Nullable Map<String, String> carrier, String key, String value) {
            if (carrier != null) {
                carrier.put(key, value);
            }
        }
    }
}

