/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.internal.util.memoizers.FunctionMemoizer;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import io.opentelemetry.semconv.UserAgentAttributes;
import io.opentelemetry.semconv.incubating.ContainerIncubatingAttributes;
import io.opentelemetry.semconv.incubating.DbIncubatingAttributes;
import io.opentelemetry.semconv.incubating.HostIncubatingAttributes;
import io.opentelemetry.semconv.incubating.MessagingIncubatingAttributes;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class AttributesKeyCache {
    private static final Map<String, AttributeKey<?>> attributeKeyMap = new HashMap(175, 0.75f);
    private final Function<String, Long> stringToLong = FunctionMemoizer.memoize(Long::valueOf);
    private final Function<String, Double> stringToDouble = FunctionMemoizer.memoize(Double::valueOf);
    private final Object lock = new Object();

    private static void mapFields(Field[] declaredFields) {
        for (Field declaredField : declaredFields) {
            if (!declaredField.getType().isAssignableFrom(AttributeKey.class)) continue;
            try {
                AttributeKey key = (AttributeKey)declaredField.get(null);
                attributeKeyMap.put(key.toString(), key);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeKey<?> getAttributeKey(String keyString) {
        AttributeKey key = attributeKeyMap.get(keyString);
        if (key == null) {
            key = AttributeKey.stringKey((String)keyString);
            Object object = this.lock;
            synchronized (object) {
                attributeKeyMap.put(keyString, key);
            }
        }
        return key;
    }

    public <T> T convertValue(AttributeKey<T> key, String value) {
        if (value == null) {
            return null;
        }
        switch (key.getType()) {
            case STRING: {
                return (T)value;
            }
            case LONG: {
                return (T)this.stringToLong.apply(value);
            }
            case DOUBLE: {
                return (T)this.stringToDouble.apply(value);
            }
            case BOOLEAN: {
                return (T)Boolean.valueOf(value);
            }
            case STRING_ARRAY: {
                return (T)new String[]{value};
            }
            case LONG_ARRAY: {
                return (T)new Long[]{(Long)this.convertValue(AttributeKey.longKey((String)"temp"), value)};
            }
            case DOUBLE_ARRAY: {
                return (T)new Double[]{(Double)this.convertValue(AttributeKey.doubleKey((String)"temp"), value)};
            }
            case BOOLEAN_ARRAY: {
                return (T)new Boolean[]{(Boolean)this.convertValue(AttributeKey.booleanKey((String)"temp"), value)};
            }
        }
        throw new IllegalArgumentException("Unsupported attribute type: " + key.getType());
    }

    static {
        AttributesKeyCache.mapFields(SemanticAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(HttpAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(UrlAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(UserAgentAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(ServerAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(DbIncubatingAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(HostIncubatingAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(ContainerIncubatingAttributes.class.getDeclaredFields());
        AttributesKeyCache.mapFields(MessagingIncubatingAttributes.class.getDeclaredFields());
    }
}

