/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.resources.ProcessResource;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.incubating.ProcessIncubatingAttributes;

public class MuleResource {
    private static Resource INSTANCE = MuleResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    public static void refresh() {
        INSTANCE = MuleResource.buildResource();
    }

    private static Resource buildResource() {
        AttributesBuilder builder = Attributes.builder();
        OpenTelemetryUtil.addAttribute("mule.home", builder, SemanticAttributes.MULE_HOME);
        OpenTelemetryUtil.addAttribute("csorganization.id", builder, SemanticAttributes.MULE_CSORGANIZATION_ID);
        OpenTelemetryUtil.addAttribute("csorganization.id", builder, SemanticAttributes.MULE_ORGANIZATION_ID);
        OpenTelemetryUtil.addAttribute("environment.id", builder, SemanticAttributes.MULE_ENVIRONMENT_ID);
        OpenTelemetryUtil.addAttribute("environment.type", builder, SemanticAttributes.MULE_ENVIRONMENT_TYPE);
        OpenTelemetryUtil.addAttribute("worker.id", builder, SemanticAttributes.MULE_WORKER_ID);
        OpenTelemetryUtil.addAttribute("domain", builder, SemanticAttributes.MULE_APP_DOMAIN);
        OpenTelemetryUtil.addAttribute("fullDomain", builder, SemanticAttributes.MULE_APP_FULL_DOMAIN);
        OpenTelemetryUtil.addAttribute("application.aws.region", builder, SemanticAttributes.MULE_ENVIRONMENT_AWS_REGION);
        MuleResource.addMuleProcessAttributes(builder);
        Attributes build = builder.build();
        return Resource.create((Attributes)build);
    }

    private static void addMuleProcessAttributes(AttributesBuilder builder) {
        String executablePath;
        Resource resource = ProcessResource.get();
        Long pid = (Long)resource.getAttribute(ProcessIncubatingAttributes.PROCESS_PID);
        if (pid != null && pid >= 0L) {
            builder.put(ProcessIncubatingAttributes.PROCESS_PID, (Object)pid);
        }
        if ((executablePath = (String)resource.getAttribute(ProcessIncubatingAttributes.PROCESS_EXECUTABLE_PATH)) != null && !executablePath.isEmpty()) {
            builder.put(ProcessIncubatingAttributes.PROCESS_EXECUTABLE_PATH, (Object)executablePath);
        }
    }

    private MuleResource() {
    }
}

