/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.connection.TraceContextHandler;
import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import com.mulesoft.extension.mq.api.attributes.AnypointMQMessageAttributes;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.semconv.UrlAttributes;
import io.opentelemetry.semconv.incubating.MessagingIncubatingAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;

public class AnypointMQProcessorComponent
extends AbstractProcessorComponent {
    private final ConcurrentHashMap<String, String> spanNamesCache = new ConcurrentHashMap();

    @Override
    protected String getNamespace() {
        return "anypoint-mq";
    }

    @Override
    protected List<String> getOperations() {
        return Arrays.asList("publish", "consume", "ack", "nack");
    }

    @Override
    protected List<String> getSources() {
        return Collections.singletonList("subscriber");
    }

    @Override
    protected SpanKind getSpanKind() {
        return SpanKind.PRODUCER;
    }

    private String formattedSpanName(String queueName, String operation) {
        String key = queueName + operation;
        return this.spanNamesCache.computeIfAbsent(key, k -> queueName + " " + operation);
    }

    @Override
    public TraceComponent getStartTraceComponent(Component component, Event event) {
        TraceComponent startTraceComponent = super.getStartTraceComponent(component, event);
        if ("consume".equalsIgnoreCase(startTraceComponent.getTag(SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey()))) {
            startTraceComponent = startTraceComponent.withSpanKind(SpanKind.CONSUMER).withSpanName(this.formattedSpanName(startTraceComponent.getTag(MessagingIncubatingAttributes.MESSAGING_DESTINATION_NAME.getKey()), "receive"));
        }
        return startTraceComponent;
    }

    @Override
    protected <A> void addAttributes(Component component, TypedValue<A> attributes, TraceComponent collector) {
        ComponentWrapper componentWrapper = this.componentRegistryService.getComponentWrapper(component);
        Map<String, String> connectionParams = componentWrapper.getConfigConnectionParameters();
        collector.addTag(MessagingIncubatingAttributes.MESSAGING_CLIENT_ID.getKey(), connectionParams.get("clientId"));
        if (attributes != null && attributes.getValue() instanceof AnypointMQMessageAttributes) {
            AnypointMQMessageAttributes attrs = (AnypointMQMessageAttributes)attributes.getValue();
            collector.addTag(MessagingIncubatingAttributes.MESSAGING_MESSAGE_ID.getKey(), attrs.getMessageId());
        }
        collector.addTag(MessagingIncubatingAttributes.MESSAGING_SYSTEM.getKey(), "anypointmq");
        this.addTagIfPresent(componentWrapper.getParameters(), "destination", collector, MessagingIncubatingAttributes.MESSAGING_DESTINATION_NAME.getKey());
        this.addTagIfPresent(connectionParams, "url", collector, UrlAttributes.URL_FULL.getKey());
    }

    @Override
    public TraceComponent getSourceStartTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        TypedValue attributesTypedValue = notification.getEvent().getMessage().getAttributes();
        AnypointMQMessageAttributes attributes = (AnypointMQMessageAttributes)attributesTypedValue.getValue();
        Component sourceComponent = this.getSourceComponent(notification);
        if (sourceComponent == null) {
            sourceComponent = notification.getComponent();
        }
        TraceComponent traceComponent = this.getTraceComponentBuilderFor(notification);
        this.addAttributes(sourceComponent, attributesTypedValue, traceComponent);
        traceComponent.addTag(MessagingIncubatingAttributes.MESSAGING_OPERATION_NAME.getKey(), "process");
        return traceComponent.withSpanName(this.formattedSpanName(attributes.getDestination(), "process")).withStatsCode(StatusCode.OK).withSpanKind(SpanKind.CONSUMER).withContext(traceContextHandler.getTraceContext(attributes.getProperties(), AbstractProcessorComponent.ContextMapGetter.INSTANCE));
    }

    @Override
    public TraceComponent getEndTraceComponent(EnrichedServerNotification notification) {
        return this.getTraceComponentBuilderFor(notification).withStatsCode(StatusCode.OK);
    }

    @Override
    public TraceComponent getSourceEndTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        return this.getTraceComponentBuilderFor(notification).withStatsCode(StatusCode.OK);
    }
}

