/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.processor.ProcessorComponent;
import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.connection.TraceContextHandler;
import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ProcessorComponentService;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.TraceComponentManager;
import com.avioconsulting.mule.opentelemetry.internal.util.BatchHelperUtil;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;

public class FlowProcessorComponent
extends AbstractProcessorComponent {
    @Override
    public boolean canHandle(ComponentIdentifier componentIdentifier) {
        return this.namespaceSupported(componentIdentifier) && this.operationSupported(componentIdentifier);
    }

    @Override
    protected String getNamespace() {
        return "mule";
    }

    @Override
    protected List<String> getSources() {
        return Collections.emptyList();
    }

    @Override
    protected List<String> getOperations() {
        return Collections.singletonList("flow");
    }

    @Override
    public TraceComponent getStartTraceComponent(EnrichedServerNotification notification) {
        TraceComponent traceComponent = TraceComponentManager.getInstance().createTraceComponent(this.getTransactionId(notification), notification.getResourceIdentifier(), notification.getComponent().getLocation());
        this.addProcessorCommonTags(notification.getComponent(), traceComponent);
        traceComponent.addTag(SemanticAttributes.MULE_APP_FLOW_NAME.getKey(), notification.getResourceIdentifier());
        traceComponent.addTag(SemanticAttributes.MULE_SERVER_ID.getKey(), notification.getServerId());
        traceComponent.addTag(SemanticAttributes.MULE_CORRELATION_ID.getKey(), notification.getEvent().getCorrelationId());
        traceComponent.withSpanName(notification.getResourceIdentifier()).withLocation(notification.getResourceIdentifier());
        BatchHelperUtil.addBatchTags(traceComponent, notification.getEvent());
        return traceComponent;
    }

    @Override
    public TraceComponent getSourceStartTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        TraceComponent startTraceComponent = this.getStartTraceComponent(notification).withSpanKind(SpanKind.SERVER);
        ComponentIdentifier sourceIdentifier = this.getSourceIdentifier(notification);
        if (sourceIdentifier == null) {
            startTraceComponent.withSpanKind(SpanKind.INTERNAL);
            if (notification.getEvent().getVariables().containsKey("OTEL_TRACE_CONTEXT")) {
                TypedValue contextMap = (TypedValue)notification.getEvent().getVariables().get("OTEL_TRACE_CONTEXT");
                Context traceContext = traceContextHandler.getTraceContext(contextMap.getValue(), AbstractProcessorComponent.ContextMapGetter.INSTANCE);
                startTraceComponent.withContext(traceContext);
            }
            return startTraceComponent;
        }
        startTraceComponent.addTag(SemanticAttributes.MULE_APP_FLOW_SOURCE_NAME.getKey(), sourceIdentifier.getName());
        startTraceComponent.addTag(SemanticAttributes.MULE_APP_FLOW_SOURCE_NAMESPACE.getKey(), sourceIdentifier.getNamespace());
        ComponentWrapper sourceWrapper = this.componentRegistryService.getComponentWrapper(this.componentRegistryService.findComponentByLocation(notification.getEvent().getContext().getOriginatingLocation().getLocation()));
        startTraceComponent.addTag(SemanticAttributes.MULE_APP_FLOW_SOURCE_CONFIG_REF.getKey(), sourceWrapper.getConfigRef());
        ProcessorComponent processorComponentFor = ProcessorComponentService.getInstance().getProcessorComponentFor(sourceIdentifier, this.expressionManager, this.componentRegistryService);
        if (processorComponentFor != null) {
            try (TraceComponent sourceTrace = processorComponentFor.getSourceStartTraceComponent(notification, traceContextHandler);){
                if (sourceTrace != null) {
                    SpanKind sourceKind = sourceTrace.getSpanKind() != null ? sourceTrace.getSpanKind() : SpanKind.SERVER;
                    sourceTrace.copyTagsTo(startTraceComponent);
                    startTraceComponent.withSpanKind(sourceKind).withSpanName(sourceTrace.getSpanName()).withTransactionId(sourceTrace.getTransactionId()).withContext(sourceTrace.getContext());
                }
            }
        }
        return startTraceComponent;
    }

    @Override
    public TraceComponent getSourceEndTraceComponent(EnrichedServerNotification notification, TraceContextHandler traceContextHandler) {
        ComponentIdentifier sourceIdentifier;
        TraceComponent traceComponent = this.getEndTraceComponent(notification);
        if (notification.getException() != null) {
            traceComponent.withStatsCode(StatusCode.ERROR);
        }
        if ((sourceIdentifier = this.getSourceIdentifier(notification)) == null) {
            return traceComponent;
        }
        ProcessorComponent processorComponent = ProcessorComponentService.getInstance().getProcessorComponentFor(sourceIdentifier, this.expressionManager, this.componentRegistryService);
        if (processorComponent != null) {
            try (TraceComponent sourceTrace = processorComponent.getSourceEndTraceComponent(notification, traceContextHandler);){
                if (sourceTrace != null) {
                    sourceTrace.copyTagsTo(traceComponent);
                    traceComponent.withStatsCode(sourceTrace.getStatusCode());
                }
            }
        }
        return traceComponent;
    }
}

