/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.config.TraceLevelConfiguration;
import com.avioconsulting.mule.opentelemetry.api.ee.batch.BatchJobInstance;
import com.avioconsulting.mule.opentelemetry.api.ee.batch.BatchJobInstanceStatus;
import com.avioconsulting.mule.opentelemetry.api.ee.batch.BatchStep;
import com.avioconsulting.mule.opentelemetry.api.ee.batch.Record;
import com.avioconsulting.mule.opentelemetry.api.ee.batch.notifications.OtelBatchNotification;
import com.avioconsulting.mule.opentelemetry.api.processor.ProcessorComponent;
import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionMeta;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import com.avioconsulting.mule.opentelemetry.internal.interceptor.InterceptorProcessorConfig;
import com.avioconsulting.mule.opentelemetry.internal.notifications.BatchError;
import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.FlowProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.GenericProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ComponentRegistryService;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ProcessorComponentService;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.TraceComponentManager;
import com.avioconsulting.mule.opentelemetry.internal.util.BatchHelperUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.memoizers.FunctionMemoizer;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.AsyncMessageNotification;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.api.util.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleNotificationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MuleNotificationProcessor.class);
    public static final String MULE_OTEL_SPAN_PROCESSORS_ENABLE_PROPERTY_NAME = "mule.otel.span.processors.enable";
    public static final List<String> CONTEXT_EXPRESSIONS = Arrays.asList("#[attributes.headers]", "#[attributes.properties]", "#[attributes.properties.userProperties]", "#[payload.message.messageAttributes]");
    private Supplier<OpenTelemetryConnection> connectionSupplier;
    private boolean spanAllProcessors;
    private TraceLevelConfiguration traceLevelConfiguration;
    private OpenTelemetryConnection openTelemetryConnection;
    private final TraceComponentManager traceComponentManager = TraceComponentManager.getInstance();
    private ProcessorComponentService processorComponentService;
    private final ProcessorComponent flowProcessorComponent;
    private final InterceptorProcessorConfig interceptorProcessorConfig;
    private final ConcurrentHashMap<String, String> flowContextExpressions = new ConcurrentHashMap();
    private final ProcessorComponent genericProcessorComponent;
    private final ComponentRegistryService componentRegistryService;
    private final FunctionMemoizer<ComponentIdentifier, ProcessorComponent> resolveProcessorComponent = FunctionMemoizer.memoize(this::resolveProcessorComponent, true);

    @Inject
    public MuleNotificationProcessor(ComponentRegistryService componentRegistryService) {
        this.flowProcessorComponent = new FlowProcessorComponent().withComponentRegistryService(componentRegistryService);
        this.genericProcessorComponent = new GenericProcessorComponent().withComponentRegistryService(componentRegistryService);
        this.interceptorProcessorConfig = new InterceptorProcessorConfig().setComponentRegistryService(componentRegistryService);
        this.componentRegistryService = componentRegistryService;
    }

    MuleNotificationProcessor setProcessorComponentService(ProcessorComponentService processorComponentService) {
        this.processorComponentService = processorComponentService;
        return this;
    }

    public ComponentRegistryService getComponentRegistryService() {
        return this.componentRegistryService;
    }

    public InterceptorProcessorConfig getInterceptorProcessorConfig() {
        return this.interceptorProcessorConfig;
    }

    public boolean hasConnection() {
        return this.openTelemetryConnection != null;
    }

    public OpenTelemetryConnection getOpenTelemetryConnection() {
        return this.openTelemetryConnection;
    }

    public Supplier<OpenTelemetryConnection> getConnectionSupplier() {
        return this.connectionSupplier;
    }

    public void init(OpenTelemetryConnection connection, TraceLevelConfiguration traceLevelConfiguration) {
        this.openTelemetryConnection = connection;
        this.spanAllProcessors = Boolean.parseBoolean(System.getProperty(MULE_OTEL_SPAN_PROCESSORS_ENABLE_PROPERTY_NAME, Boolean.toString(traceLevelConfiguration.isSpanAllProcessors())));
        this.traceLevelConfiguration = traceLevelConfiguration;
        this.interceptorProcessorConfig.setTurnOffTracing(this.openTelemetryConnection.isTurnOffTracing()).updateTraceConfiguration(traceLevelConfiguration);
        this.componentRegistryService.initializeComponentWrapperRegistry();
        this.processorComponentService = ProcessorComponentService.getInstance();
    }

    public void handleProcessorStartEvent(MessageProcessorNotification notification) {
        String location = notification.getComponent().getLocation().getLocation();
        if (ComponentsUtil.isAsyncScope(notification.getComponent().getLocation().getComponentIdentifier())) {
            return;
        }
        if (this.interceptorProcessorConfig.shouldIntercept(notification.getComponent().getLocation(), notification.getEvent())) {
            if (logger.isTraceEnabled()) {
                logger.trace("Component {} will be processed by interceptor, skipping notification processing to create span", (Object)location);
            }
            return;
        }
        this.processComponentStartSpan((EnrichedServerNotification)notification);
    }

    public void handleAsyncScheduledEvent(AsyncMessageNotification notification) {
        this.processComponentStartSpan((EnrichedServerNotification)notification);
    }

    private void processComponentStartSpan(EnrichedServerNotification notification) {
        block15: {
            try {
                ProcessorComponent processorComponent = this.getProcessorComponent(notification.getComponent().getIdentifier());
                if (processorComponent == null) break block15;
                if (logger.isTraceEnabled()) {
                    logger.trace("Handling '{}:{}' processor start event context id {} correlation id {} ", new Object[]{notification.getResourceIdentifier(), notification.getComponent().getIdentifier(), notification.getEvent().getContext().getId(), notification.getEvent().getCorrelationId()});
                }
                try (TraceComponent traceComponent = processorComponent.getStartTraceComponent(notification);){
                    traceComponent.withStartTime(Instant.ofEpochMilli(notification.getTimestamp())).withEventContextId(notification.getEvent().getContext().getId()).withComponentLocation(notification.getComponent().getLocation());
                    BatchHelperUtil.addBatchTags(traceComponent, notification.getEvent());
                    OpenTelemetryUtil.resolveExpressions(traceComponent, this.openTelemetryConnection.getExpressionManager(), notification.getEvent());
                    long siblings = this.componentRegistryService.findSiblingCount(notification.getComponent().getLocation().getLocation());
                    traceComponent.withSiblings(siblings);
                    this.openTelemetryConnection.addProcessorSpan(traceComponent, ComponentsUtil.getLocationParent(notification.getComponent().getLocation().getLocation()));
                    this.processFlowRef(traceComponent, notification.getEvent());
                }
            }
            catch (Exception ex) {
                if (!logger.isTraceEnabled()) break block15;
                logger.trace("Failed to intercept processor {} at {}, span may not be captured for this processor. Error - {}", new Object[]{notification.getComponent().getIdentifier().toString(), notification.getComponent().getLocation().getLocation(), ex.getLocalizedMessage(), ex});
            }
        }
    }

    private void processFlowRef(TraceComponent traceComponent, Event event) {
        if (ComponentsUtil.isFlowRef(traceComponent.getComponentLocation())) {
            ComponentLocation subFlowLocation = ComponentsUtil.resolveFlowName(this.getOpenTelemetryConnection().getExpressionManager(), traceComponent, () -> ((Event)event).asBindingContext(), this.componentRegistryService);
            if (subFlowLocation != null) {
                try (TraceComponent subflowTrace = ComponentsUtil.getSubFlowTraceComponent(subFlowLocation, traceComponent);){
                    this.getOpenTelemetryConnection().addProcessorSpan(subflowTrace, traceComponent.getComponentLocation().getLocation());
                }
            }
        }
    }

    public ProcessorComponent resolveProcessorComponent(ComponentIdentifier identifier) {
        boolean ignored = this.multiMapContains(identifier.getNamespace(), identifier.getName(), "*", this.traceLevelConfiguration.getIgnoreMuleComponentsMap());
        if (this.spanAllProcessors && ignored) {
            return null;
        }
        ProcessorComponent processorComponent = this.processorComponentService.getProcessorComponentFor(identifier, this.openTelemetryConnection.getExpressionManager(), this.componentRegistryService);
        if (processorComponent == null && (this.spanAllProcessors || this.multiMapContains(identifier.getNamespace(), identifier.getName(), "*", this.traceLevelConfiguration.getSpanAdditionalMuleComponentsMap()))) {
            processorComponent = this.genericProcessorComponent;
        }
        return processorComponent;
    }

    private boolean multiMapContains(String key, String value, String alternate, MultiMap<String, String> multiMap) {
        List values = multiMap.getAll((Object)key);
        return values.contains(value) || values.contains(alternate);
    }

    public ProcessorComponent getProcessorComponent(ComponentIdentifier identifier) {
        return this.resolveProcessorComponent.apply(identifier);
    }

    public void handleProcessorEndEvent(EnrichedServerNotification notification) {
        block29: {
            String location = notification.getComponent().getLocation().getLocation();
            try {
                SpanMeta spanMeta;
                Error error;
                block30: {
                    ProcessorComponent processorComponent = this.getProcessorComponent(notification.getComponent().getIdentifier());
                    if (processorComponent == null) break block29;
                    if (logger.isTraceEnabled()) {
                        logger.trace("Handling '{}:{}' processor end event context id {} correlation id {} ", new Object[]{notification.getResourceIdentifier(), notification.getComponent().getIdentifier(), notification.getEvent().getContext().getId(), notification.getEvent().getCorrelationId()});
                    }
                    error = notification.getEvent().getError().orElse(null);
                    try (TraceComponent traceComponent = processorComponent.getEndTraceComponent(notification);){
                        SpanMeta subFlowSpanMeta;
                        ComponentLocation subFlowLocation;
                        traceComponent.withEndTime(Instant.ofEpochMilli(notification.getTimestamp())).withEventContextId(notification.getEvent().getContext().getId());
                        BatchHelperUtil.addBatchTags(traceComponent, notification.getEvent());
                        spanMeta = this.openTelemetryConnection.endProcessorSpan(traceComponent, error);
                        if (!ComponentsUtil.isFlowRef(notification.getComponent().getLocation()) || (subFlowLocation = ComponentsUtil.resolveFlowName(this.openTelemetryConnection.getExpressionManager(), traceComponent, () -> notification.getEvent().asBindingContext(), this.componentRegistryService)) == null) break block30;
                        try (TraceComponent subflowTrace = ComponentsUtil.getSubFlowTraceComponent(subFlowLocation, traceComponent);){
                            subFlowSpanMeta = this.openTelemetryConnection.endProcessorSpan(subflowTrace, error);
                        }
                        if (subFlowSpanMeta != null) {
                            this.openTelemetryConnection.getMetricsProviders().captureProcessorMetrics(notification.getComponent(), error, location, subFlowSpanMeta);
                        }
                    }
                }
                if (spanMeta != null) {
                    this.openTelemetryConnection.getMetricsProviders().captureProcessorMetrics(notification.getComponent(), error, location, spanMeta);
                }
            }
            catch (Exception ex) {
                logger.error("Error in handling processor end event", (Throwable)ex);
                throw ex;
            }
        }
    }

    public void handleFlowStartEvent(PipelineMessageNotification notification) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace("Handling '{}' flow start event context id {} correlation id {} ", new Object[]{notification.getResourceIdentifier(), notification.getEvent().getContext().getId(), notification.getEvent().getCorrelationId()});
            }
            try (TraceComponent traceComponent = this.flowProcessorComponent.getSourceStartTraceComponent((EnrichedServerNotification)notification, this.openTelemetryConnection);){
                traceComponent.withStartTime(Instant.ofEpochMilli(notification.getTimestamp())).withEventContextId(notification.getEvent().getContext().getId());
                this.attemptAddingTraceContextIfMissing(notification, traceComponent);
                BatchHelperUtil.addBatchTags(traceComponent, notification.getEvent());
                this.openTelemetryConnection.startTransaction(traceComponent);
            }
        }
        catch (Exception ex) {
            logger.error("Error in handling {} flow start event", (Object)notification.getResourceIdentifier(), (Object)ex);
            throw ex;
        }
    }

    private TraceComponent attemptAddingTraceContextIfMissing(PipelineMessageNotification notification, TraceComponent traceComponent) {
        if (traceComponent.getContext() != null || !PropertiesUtil.isDynamicContextDetectionEnabled()) {
            return traceComponent;
        }
        if (this.flowContextExpressions.containsKey(notification.getResourceIdentifier())) {
            String expression = this.flowContextExpressions.get(notification.getResourceIdentifier());
            if (logger.isTraceEnabled()) {
                logger.trace("Getting context for {} with {}", (Object)notification.getResourceIdentifier(), (Object)expression);
            }
            Context context = this.getContext(expression, (EnrichedServerNotification)notification);
            traceComponent = traceComponent.withContext(context);
        } else {
            for (String expression : CONTEXT_EXPRESSIONS) {
                if (traceComponent.getContext() != null) continue;
                try {
                    Context context = this.getContext(expression, (EnrichedServerNotification)notification);
                    if (context == null) continue;
                    traceComponent = traceComponent.withContext(context);
                    logger.info("Got context for {} with {}, adding to cache", (Object)notification.getResourceIdentifier(), (Object)expression);
                    this.flowContextExpressions.put(notification.getResourceIdentifier(), expression);
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        return traceComponent;
    }

    private Context getContext(String expression, EnrichedServerNotification notification) {
        try {
            TypedValue contextCarrier = this.openTelemetryConnection.getExpressionManager().evaluate(expression, notification.getEvent().asBindingContext());
            if (contextCarrier.getValue() != null && contextCarrier.getValue() instanceof Map) {
                HashMap resolved = new HashMap(((Map)contextCarrier.getValue()).size());
                ((Map)contextCarrier.getValue()).forEach((key, value) -> {
                    if (value instanceof byte[]) {
                        resolved.put(key.toString(), new String((byte[])value));
                    } else {
                        resolved.put(key.toString(), value.toString());
                    }
                });
                return this.openTelemetryConnection.getTraceContext(resolved, AbstractProcessorComponent.ContextMapGetter.INSTANCE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void handleFlowEndEvent(PipelineMessageNotification notification) {
        try {
            TransactionMeta transactionMeta;
            if (logger.isTraceEnabled()) {
                logger.trace("Handling '{}' flow end event context id {} correlation id {} ", new Object[]{notification.getResourceIdentifier(), notification.getEvent().getContext().getId(), notification.getEvent().getCorrelationId()});
            }
            try (TraceComponent traceComponent = this.flowProcessorComponent.getSourceEndTraceComponent((EnrichedServerNotification)notification, this.openTelemetryConnection);){
                traceComponent.withEndTime(Instant.ofEpochMilli(notification.getTimestamp())).withEventContextId(notification.getEvent().getContext().getId());
                BatchHelperUtil.addBatchTags(traceComponent, notification.getEvent());
                transactionMeta = this.openTelemetryConnection.endTransaction(traceComponent, notification.getException());
                if (transactionMeta == null) {
                    TypedValue contextId = (TypedValue)notification.getEvent().getVariables().get("_OTEL_FLOW_CONTEXT_ID");
                    if (contextId != null && contextId.getValue() != null) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Attempting to find {} by {}", (Object)traceComponent, contextId.getValue());
                        }
                        traceComponent.withEventContextId((String)contextId.getValue());
                    }
                    transactionMeta = this.openTelemetryConnection.endTransaction(traceComponent, notification.getException());
                }
            }
            if (transactionMeta != null) {
                this.openTelemetryConnection.getMetricsProviders().captureFlowMetrics(transactionMeta, notification.getResourceIdentifier(), notification.getException());
            }
        }
        catch (Exception ex) {
            logger.error("Error in handling {} flow end event", (Object)notification.getResourceIdentifier(), (Object)ex);
            throw ex;
        }
    }

    public void handleBatchOnCompleteEndEvent(OtelBatchNotification batchNotification) {
        BatchJobInstance jobInstance = batchNotification.getJobInstance();
        try (TraceComponent traceComponent = TraceComponentManager.getInstance().createTraceComponent(jobInstance.getId(), "batch:on-complete");){
            traceComponent.withSpanName("batch:on-complete").withEndTime(Instant.ofEpochMilli(batchNotification.getTimestamp()));
            traceComponent.addTag(SemanticAttributes.MULE_BATCH_JOB_INSTANCE_ID.toString(), jobInstance.getId());
            this.openTelemetryConnection.endProcessorSpan(traceComponent, BatchError.of(batchNotification.getException()));
            if (BatchJobInstanceStatus.FAILED_PROCESS_RECORDS.equals((Object)batchNotification.getJobInstance().getStatus())) {
                this.handleBatchEndEvent(batchNotification);
            }
        }
    }

    public void handleBatchEndEvent(OtelBatchNotification batchNotification) {
        BatchJobInstance jobInstance = batchNotification.getJobInstance();
        try (TraceComponent traceComponent = this.traceComponentManager.createTraceComponent(jobInstance.getId(), batchNotification.getJobInstance().getOwnerJobName());){
            traceComponent.withEndTime(Instant.ofEpochMilli(batchNotification.getTimestamp()));
            this.openTelemetryConnection.endTransaction(traceComponent, batchNotification.getException());
        }
    }

    public void handleBatchStepRecordEndEvent(OtelBatchNotification batchNotification) {
        BatchJobInstance jobInstance = batchNotification.getJobInstance();
        BatchStep batchStep = batchNotification.getStep();
        Record record = batchNotification.getRecord();
        String recordLocation = batchNotification.getStep().getComponent().getLocation().getLocation();
        recordLocation = recordLocation + "/record";
        try (TraceComponent traceComponent = TraceComponentManager.getInstance().createTraceComponent(jobInstance.getId(), "batch:step-record");){
            traceComponent.withLocation(recordLocation).withSpanName("batch:step-record").withEndTime(Instant.ofEpochMilli(batchNotification.getTimestamp())).withEventContextId(record.getVariable("OTEL_BATCH_STEP_RECORD_CONTEXT_ID").getValue().toString());
            traceComponent.addTag(SemanticAttributes.MULE_BATCH_JOB_INSTANCE_ID.getKey(), jobInstance.getId());
            traceComponent.addTag(SemanticAttributes.MULE_BATCH_JOB_NAME.getKey(), jobInstance.getOwnerJobName());
            traceComponent.addTag(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey(), batchStep.getName());
            this.openTelemetryConnection.endProcessorSpan(traceComponent, BatchError.of(record.getExceptionForStep(record.getCurrentStepId())));
        }
    }

    public void handleBatchStepEndEvent(OtelBatchNotification batchNotification) {
        BatchJobInstance jobInstance = batchNotification.getJobInstance();
        BatchStep batchStep = batchNotification.getStep();
        try (TraceComponent traceComponent = TraceComponentManager.getInstance().createTraceComponent(jobInstance.getId(), "batch:step");){
            traceComponent.withSpanName(batchStep.getName()).withEndTime(Instant.ofEpochMilli(batchNotification.getTimestamp()));
            traceComponent.addTag(SemanticAttributes.MULE_BATCH_JOB_INSTANCE_ID.getKey(), jobInstance.getId());
            traceComponent.addTag(SemanticAttributes.MULE_BATCH_JOB_NAME.getKey(), jobInstance.getOwnerJobName());
            traceComponent.addTag(SemanticAttributes.MULE_BATCH_JOB_STEP_NAME.getKey(), batchStep.getName());
            this.openTelemetryConnection.endProcessorSpan(traceComponent, null);
        }
    }
}

