/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor.service;

import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ComponentLocatorService;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.memoizers.FunctionMemoizer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentRegistryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentRegistryService.class);
    private final ComponentLocatorService componentLocatorService;
    private final ConcurrentHashMap<String, ComponentWrapper> componentWrapperRegistry = new ConcurrentHashMap();
    public final Map<String, String> OTEL_SYSTEM_PROPERTIES_MAP = System.getProperties().stringPropertyNames().stream().filter(p -> p.contains(".otel.")).collect(Collectors.toMap(String::toLowerCase, System::getProperty));
    private final FunctionMemoizer<String, Map<String, String>> getGlobalConfigOtelSystemProperties = FunctionMemoizer.memoize(configName -> OpenTelemetryUtil.getGlobalConfigSystemAttributes(configName, this.OTEL_SYSTEM_PROPERTIES_MAP));

    @Inject
    public ComponentRegistryService(ConfigurationComponentLocator configurationComponentLocator) {
        this.componentLocatorService = new ComponentLocatorService(configurationComponentLocator);
    }

    public void initializeComponentWrapperRegistry() {
        this.componentWrapperRegistry.clear();
        Map<String, ComponentLocation> locations = this.componentLocatorService.getAllComponentLocations();
        for (String location : locations.keySet()) {
            Component component;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Finding component wrapper for {}", (Object)location);
            }
            if ((component = this.componentLocatorService.findComponentByLocation(location)) == null) {
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Component not found for location {}, it may have not been initialized. Later lookups will resolve it when needed.", (Object)location);
                continue;
            }
            try {
                ComponentWrapper wrapper = this.createNewWrapper(component);
                this.componentWrapperRegistry.put(component.getLocation().getLocation(), wrapper);
            }
            catch (Exception ex) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Could not pre-initialize component wrapper for {}. Processing will continue and wrapper may be initialized when needed.", (Object)location);
                }
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("Exception during initialization of component wrapper for {}.", (Object)location, (Object)ex);
            }
        }
    }

    private ComponentWrapper createNewWrapper(Component component) {
        ComponentWrapper wrapper = new ComponentWrapper(component, this);
        if (wrapper.getConfigRef() != null) {
            this.getGlobalConfigOtelSystemProperties.apply(wrapper.getConfigRef());
        }
        return wrapper;
    }

    public Map<String, String> getOtelSystemPropertiesMap() {
        return this.OTEL_SYSTEM_PROPERTIES_MAP;
    }

    public Map<String, String> getGlobalConfigOtelSystemProperties(String configName) {
        return this.getGlobalConfigOtelSystemProperties.apply(configName);
    }

    public ComponentWrapper getComponentWrapper(Component component) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Getting component wrapper for {}", (Object)component.getLocation().getLocation());
        }
        return this.componentWrapperRegistry.computeIfAbsent(component.getLocation().getLocation(), c -> this.createNewWrapper(component));
    }

    public Map<String, ComponentLocation> getAllComponentLocations() {
        return this.componentLocatorService.getAllComponentLocations();
    }

    public ComponentLocation findComponentLocation(String location) {
        return this.componentLocatorService.findComponentLocation(location);
    }

    public long findSiblingCount(String location) {
        return this.componentLocatorService.findSiblingCount(location);
    }

    public Component findComponentByLocation(String location) {
        return this.componentLocatorService.findComponentByLocation(location);
    }

    public Component findComponentByLocation(ComponentLocation location) {
        return this.componentLocatorService.findComponentByLocation(location);
    }
}

