/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor.service;

import com.avioconsulting.mule.opentelemetry.api.processor.ProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ComponentRegistryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.el.ExpressionManager;

public class ProcessorComponentService {
    private static ProcessorComponentService service;
    private final List<ProcessorComponent> processorComponents;
    private static final LazyValue<ProcessorComponentService> VALUE;
    private final Map<ComponentIdentifier, ProcessorComponent> cachedMap = new ConcurrentHashMap<ComponentIdentifier, ProcessorComponent>();

    private ProcessorComponentService() {
        ServiceLoader<ProcessorComponent> loader = ServiceLoader.load(ProcessorComponent.class, ProcessorComponent.class.getClassLoader());
        ArrayList lst = new ArrayList();
        loader.iterator().forEachRemaining(lst::add);
        this.processorComponents = Collections.unmodifiableList(lst);
    }

    public static synchronized ProcessorComponentService getInstance() {
        return (ProcessorComponentService)VALUE.get();
    }

    public ProcessorComponent getProcessorComponentFor(ComponentIdentifier identifier, ExpressionManager expressionManager, ComponentRegistryService componentRegistryService) {
        return this.cachedMap.computeIfAbsent(identifier, id -> {
            for (ProcessorComponent pc : this.processorComponents) {
                if (!pc.canHandle(identifier)) continue;
                pc.withExpressionManager(expressionManager).withComponentRegistryService(componentRegistryService);
                return pc;
            }
            return null;
        });
    }

    static {
        VALUE = new LazyValue((Object)new ProcessorComponentService());
    }
}

