/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor.util;

import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.Borrowable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

public class PooledTraceComponent
extends TraceComponent
implements Borrowable {
    private final Consumer<TraceComponent> onClose;
    private static final int INITIAL_TAG_MAP_CAPACITY = 64;
    private final String id = UUID.randomUUID().toString();
    private long borrowedAt;

    PooledTraceComponent(String transactionId, String name, Consumer<TraceComponent> onClose) {
        super(name, new HashMap<String, String>(64));
        this.withTransactionId(transactionId);
        this.onClose = Objects.requireNonNull(onClose);
    }

    public String getId() {
        return this.id;
    }

    void reset(String transactionId, String name) {
        this.setName(name).withTransactionId(transactionId).withStartTime(Instant.now());
    }

    @Override
    public void close() {
        this.onClose.accept(this);
    }

    @Override
    public long getBorrowedAt() {
        return this.borrowedAt;
    }

    @Override
    public TraceComponent withBorrowedAt(long borrowedAt) {
        this.borrowedAt = borrowedAt;
        return this;
    }
}

