/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionMeta;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.store.AbstractTransaction;
import com.avioconsulting.mule.opentelemetry.internal.store.FlowSpan;
import com.avioconsulting.mule.opentelemetry.internal.store.ProcessorSpan;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import java.time.Instant;
import java.util.Map;
import java.util.function.Consumer;

public class FlowTransaction
extends AbstractTransaction {
    private final FlowSpan rootFlowSpan;

    public FlowTransaction(String transactionId, String traceId, String rootFlowName, FlowSpan rootFlowSpan, Instant startTime) {
        super(transactionId, traceId, rootFlowName, startTime);
        this.rootFlowSpan = rootFlowSpan;
        this.setTransactionContext();
    }

    private FlowSpan getRootFlowSpan() {
        return this.rootFlowSpan;
    }

    @Override
    public Span getSpan() {
        return this.getRootFlowSpan().getSpan();
    }

    @Override
    public Map<String, String> getTags() {
        return this.getRootFlowSpan().getTags();
    }

    @Override
    public Span getTransactionSpan() {
        return this.getRootFlowSpan().getSpan();
    }

    @Override
    public void addChildTransaction(TraceComponent traceComponent, SpanBuilder spanBuilder) {
        this.getRootFlowSpan().addChildContainer(traceComponent, spanBuilder);
    }

    @Override
    public TransactionMeta endChildTransaction(TraceComponent traceComponent, Consumer<Span> endSpan) {
        return this.getRootFlowSpan().endChildContainer(traceComponent, endSpan);
    }

    @Override
    public ProcessorSpan findSpan(String location) {
        return this.getRootFlowSpan().findSpan(location);
    }

    @Override
    public boolean hasEnded() {
        return this.getEndTime() != null && this.getRootFlowSpan().childFlowsEnded();
    }

    @Override
    public SpanMeta addProcessorSpan(String containerName, TraceComponent traceComponent, SpanBuilder spanBuilder) {
        return this.getRootFlowSpan().addProcessorSpan(containerName, traceComponent, spanBuilder);
    }

    @Override
    public SpanMeta endProcessorSpan(TraceComponent traceComponent, Consumer<Span> spanUpdater, Instant endTime) {
        return this.getRootFlowSpan().endProcessorSpan(traceComponent, spanUpdater, endTime);
    }
}

