/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.util;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ComponentRegistryService;
import com.avioconsulting.mule.opentelemetry.internal.processor.util.TraceComponentManager;
import com.avioconsulting.mule.opentelemetry.internal.util.BatchHelperUtil;
import io.opentelemetry.api.trace.SpanKind;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.core.api.el.ExpressionManager;

public class ComponentsUtil {
    public static final String BATCH_AGGREGATOR = "batch:aggregator";
    private static final List<TypedComponentIdentifier.ComponentType> ROUTE_IDENTIFIERS = Arrays.asList(TypedComponentIdentifier.ComponentType.ROUTE, TypedComponentIdentifier.ComponentType.SCOPE);
    public static final String BATCH_STEP_TAG = "batch:step";
    public static final String BATCH_STEP_RECORD_TAG = "batch:step-record";
    public static final String BATCH_JOB_TAG = "batch:job";
    public static final String BATCH_ON_COMPLETE_TAG = "batch:on-complete";
    public static final String PROCESSOR_0_PATH_SUFFIX = "/processors/0";
    public static final String ASYNC = "async";
    public static final String ROUTE_NAME = "route";
    public static final String SUB_FLOW = "sub-flow";
    public static final String FLOW_REF = "flow-ref";
    public static final String BATCH = "batch";
    public static final String ON_COMPLETE = "on-complete";
    public static final String MULE_ANY = "MULE:ANY";

    public static Optional<ComponentLocation> findLocation(String location, ConfigurationComponentLocator configurationComponentLocator) {
        return configurationComponentLocator.findAllLocations().stream().filter(cl -> cl.getLocation().equals(location)).findFirst();
    }

    public static boolean isSubFlow(ComponentLocation location) {
        return location.getComponentIdentifier().getIdentifier().getName().equals(SUB_FLOW);
    }

    public static boolean isFlowRef(ComponentLocation location) {
        return location.getComponentIdentifier().getIdentifier().getName().equals(FLOW_REF);
    }

    public static Optional<Component> findComponent(ComponentIdentifier identifier, String location, ConfigurationComponentLocator configurationComponentLocator) {
        return configurationComponentLocator.find(identifier).stream().filter(c -> c.getLocation().getLocation().equals(location)).findFirst();
    }

    public static String getRouteContainerLocation(TraceComponent traceComponent) {
        String parentLocation = null;
        ComponentLocation location = traceComponent.getComponentLocation();
        if (location == null) {
            return null;
        }
        List parts = location.getParts();
        int size = parts.size();
        if (size <= 2) {
            return null;
        }
        int routeIndex = size - 3;
        LocationPart parentPart = (LocationPart)parts.get(routeIndex);
        Optional identifier = parentPart.getPartIdentifier();
        if (!identifier.filter(ComponentsUtil::isRoute).isPresent()) {
            return null;
        }
        parentLocation = identifier.map(tci -> {
            StringBuilder sb = new StringBuilder(((LocationPart)parts.get(0)).getPartPath());
            for (int i = 1; i <= routeIndex; ++i) {
                sb.append("/").append(((LocationPart)parts.get(i)).getPartPath());
            }
            return sb.toString();
        }).orElse(null);
        return parentLocation;
    }

    public static String getLocationParent(String location) {
        String locationParent = location;
        if (locationParent.contains("/")) {
            locationParent = location.substring(0, location.lastIndexOf("/"));
        }
        if (locationParent.contains("/")) {
            locationParent = locationParent.substring(0, locationParent.lastIndexOf("/"));
        }
        return locationParent;
    }

    public static boolean isRoute(TypedComponentIdentifier tci) {
        Objects.requireNonNull(tci, "Component Identifier cannot be null");
        return tci.getIdentifier().getName().equals(ROUTE_NAME) || TypedComponentIdentifier.ComponentType.ROUTE.equals((Object)tci.getType());
    }

    public static boolean isFlowTrace(TraceComponent traceComponent) {
        return traceComponent != null && traceComponent.hasTags() && "flow".equalsIgnoreCase(traceComponent.getTag(SemanticAttributes.MULE_APP_PROCESSOR_NAME.getKey()));
    }

    public static boolean isFirstProcessor(ComponentLocation location) {
        String interceptPath = location.getRootContainerName() + PROCESSOR_0_PATH_SUFFIX;
        return ComponentsUtil.isFlowTypeContainer(location) && interceptPath.equalsIgnoreCase(location.getLocation());
    }

    public static boolean isFirstProcessorInScope(ComponentLocation location) {
        if (location.getParts().size() <= 2) {
            return false;
        }
        if (!location.getLocation().endsWith(PROCESSOR_0_PATH_SUFFIX)) {
            return false;
        }
        LocationPart parentPart = (LocationPart)location.getParts().get(location.getParts().size() - 3);
        String firstProcessorPath = ComponentsUtil.getLocationParent(location.getLocation()) + PROCESSOR_0_PATH_SUFFIX;
        return parentPart.getPartIdentifier().isPresent() && ComponentsUtil.isRoute((TypedComponentIdentifier)parentPart.getPartIdentifier().get()) && firstProcessorPath.equalsIgnoreCase(location.getLocation());
    }

    public static boolean isFlowTypeContainer(ComponentLocation componentLocation) {
        return !componentLocation.getParts().isEmpty() && ((LocationPart)componentLocation.getParts().get(0)).getPartIdentifier().filter(c -> TypedComponentIdentifier.ComponentType.FLOW.equals((Object)c.getType()) || TypedComponentIdentifier.ComponentType.SCOPE.equals((Object)c.getType())).isPresent();
    }

    public static boolean isAsyncScope(TypedComponentIdentifier identifier) {
        return TypedComponentIdentifier.ComponentType.SCOPE.equals((Object)identifier.getType()) && identifier.getIdentifier().getName().equals(ASYNC);
    }

    public static TraceComponent getSubFlowTraceComponent(ComponentLocation subFlowComp, TraceComponent traceComponent) {
        TraceComponent subFlowTrace = TraceComponentManager.getInstance().createTraceComponent(traceComponent.getTransactionId(), subFlowComp).withSpanName(subFlowComp.getLocation()).withSpanKind(SpanKind.INTERNAL).withStatsCode(traceComponent.getStatusCode()).withStartTime(traceComponent.getStartTime()).withContext(traceComponent.getContext()).withEventContextId(traceComponent.getEventContextId()).withEndTime(traceComponent.getEndTime());
        subFlowTrace.addTag(SemanticAttributes.MULE_APP_SCOPE_SUBFLOW_NAME.getKey(), subFlowComp.getLocation());
        BatchHelperUtil.copyBatchTags(traceComponent, subFlowTrace);
        return subFlowTrace;
    }

    public static ComponentLocation resolveFlowName(ExpressionManager expressionManager, TraceComponent traceComponent, Supplier<BindingContext> context, ComponentRegistryService componentRegistryService) {
        ComponentLocation componentLocation;
        String targetFlowName = traceComponent.getTag(SemanticAttributes.MULE_APP_PROCESSOR_FLOW_REF_NAME.getKey());
        if (expressionManager.isExpression(targetFlowName)) {
            targetFlowName = expressionManager.evaluate(targetFlowName, context.get()).getValue().toString();
            traceComponent.addTag(SemanticAttributes.MULE_APP_PROCESSOR_FLOW_REF_NAME.getKey(), targetFlowName);
        }
        if ((componentLocation = componentRegistryService.findComponentLocation(targetFlowName)) == null) {
            return null;
        }
        if (ComponentsUtil.isSubFlow(componentLocation)) {
            return componentLocation;
        }
        return null;
    }

    public static boolean isBatchOnComplete(String location, ComponentRegistryService componentRegistryService) {
        Component component = componentRegistryService.findComponentByLocation(location);
        return component != null && BATCH.equalsIgnoreCase(component.getIdentifier().getNamespace()) && ON_COMPLETE.equalsIgnoreCase(component.getIdentifier().getName());
    }
}

