/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.util;

import java.util.Collections;
import java.util.Map;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.MDC;

public class MDCUtil {
    private static final TypedValue<Map<Object, Object>> EMPTY_MAP_VALUE = TypedValue.of(Collections.emptyMap());
    public static final String TRACE_ID = "trace_id";
    public static final String SPAN_ID = "span_id";

    public static void replaceMDCOtelEntries(Event event) {
        if (event == null) {
            return;
        }
        MDCUtil.replaceMDCOtelEntriesFromVars(event.getVariables());
    }

    public static void replaceMDCOtelEntriesFromVars(Map<String, TypedValue<?>> variables) {
        TypedValue<Map<Object, Object>> contextMap = variables.getOrDefault("OTEL_TRACE_CONTEXT", EMPTY_MAP_VALUE);
        Map context = (Map)contextMap.getValue();
        MDCUtil.replaceMDCOtelEntries(context);
    }

    public static void replaceMDCOtelEntries(Map<String, Object> context) {
        if (context == null || context.isEmpty()) {
            return;
        }
        MDCUtil.replaceMDCOtelEntry(context, "traceId", TRACE_ID);
        MDCUtil.replaceMDCOtelEntry(context, "spanId", SPAN_ID);
    }

    private static void replaceMDCOtelEntry(Map<String, Object> contextMap, String sourceKey, String targetKey) {
        if (contextMap.containsKey(sourceKey)) {
            String mdcValue = MDC.get((String)sourceKey);
            if (mdcValue != null && mdcValue.equalsIgnoreCase(contextMap.get(sourceKey).toString())) {
                return;
            }
            MDC.remove((String)targetKey);
            MDC.put((String)targetKey, (String)contextMap.get(sourceKey).toString());
        }
    }
}

