/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.util;

import java.util.Map;
import java.util.Objects;
import org.mule.runtime.api.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetryUtil.class);

    public static void addGlobalConfigSystemAttributes(String configName, Map<String, String> tags, Map<String, String> sourceMap) {
        if (configName == null || configName.trim().isEmpty()) {
            return;
        }
        Objects.requireNonNull(tags, "Tags map cannot be null");
        String configRef = configName.toLowerCase();
        String replaceVal = configRef + ".otel.";
        sourceMap.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(configRef)).forEach(entry -> {
            String propKey = ((String)entry.getKey()).substring(replaceVal.length());
            tags.put(propKey, (String)entry.getValue());
        });
    }

    public static String getEventTransactionId(Event event) {
        return event.getContext().getId().split("_")[0];
    }
}

