/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api.config;

import com.avioconsulting.mule.opentelemetry.api.config.MuleComponent;
import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class TraceLevelConfiguration {
    @Parameter
    @Optional(defaultValue="false")
    @Placement(order=1)
    @DisplayName(value="Span All Processors")
    @Summary(value="By default, Spans are created for known components only. Setting this flag to true will create trace spans for every processor in a flow.")
    private boolean spanAllProcessors = false;
    @Parameter
    @NullSafe
    @Optional
    @Placement(order=1)
    @DisplayName(value="Disable Spans for")
    @Summary(value="When generating spans for all processors, this list defines the processors that should be skipped from tracing. No spans will be generated for these components.")
    private List<MuleComponent> ignoreMuleComponents;
    @Parameter
    @NullSafe
    @Optional
    @Placement(order=1)
    @DisplayName(value="Disable Interception for")
    @Summary(value="Module uses message processor interception mechanism to inject trace context variable. Any specific message processor (namespace:name) or specific namespace (namespace:*) can be excluded from this interception process.")
    private List<MuleComponent> interceptionDisabledComponents;
    @Parameter
    @NullSafe
    @Optional
    @Placement(order=2)
    @DisplayName(value="Enable Interception for")
    @Summary(value="Module uses message processor interception mechanism to inject trace context variable. Any specific message processor (namespace:name) or specific namespace (namespace:*) can be included from this interception process.")
    private List<MuleComponent> interceptionEnabledComponents;

    public TraceLevelConfiguration() {
    }

    public TraceLevelConfiguration(boolean spanAllProcessors, List<MuleComponent> ignoreMuleComponents) {
        this(spanAllProcessors, ignoreMuleComponents, new ArrayList<MuleComponent>(), new ArrayList<MuleComponent>());
    }

    public TraceLevelConfiguration(boolean spanAllProcessors, List<MuleComponent> ignoreMuleComponents, List<MuleComponent> interceptionDisabledComponents, List<MuleComponent> interceptionEnabledComponents) {
        this.spanAllProcessors = spanAllProcessors;
        this.ignoreMuleComponents = ignoreMuleComponents;
        this.interceptionDisabledComponents = interceptionDisabledComponents;
        this.interceptionEnabledComponents = interceptionEnabledComponents;
    }

    public boolean isSpanAllProcessors() {
        return this.spanAllProcessors;
    }

    public List<MuleComponent> getIgnoreMuleComponents() {
        return this.ignoreMuleComponents;
    }

    public List<MuleComponent> getInterceptionDisabledComponents() {
        return this.interceptionDisabledComponents;
    }

    public List<MuleComponent> getInterceptionEnabledComponents() {
        return this.interceptionEnabledComponents;
    }
}

