/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api.config.exporter;

import com.avioconsulting.mule.opentelemetry.api.config.exporter.OpenTelemetryExporter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExporter
implements OpenTelemetryExporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExporter.class);
    @Parameter
    @NullSafe
    @Optional
    @Summary(value="Additional Configuration properties for Exporter. System or Environment Variables will override this configuration.")
    private Map<String, String> configProperties = new HashMap<String, String>();

    public Map<String, String> getConfigProperties() {
        return this.configProperties;
    }

    public void setConfigProperties(Map<String, String> configProperties) {
        this.configProperties = configProperties;
    }

    @Override
    public Map<String, String> getExporterProperties() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("otel.traces.exporter", "none");
        config.put("otel.metrics.exporter", "none");
        config.put("otel.logs.exporter", "none");
        config.putAll(this.getConfigProperties());
        return config;
    }

    protected String transformToAbsolutePath(String propertyName, String path) {
        if (path != null && !path.isEmpty()) {
            if (Files.exists(Paths.get(path, new String[0]), new LinkOption[0])) {
                LOGGER.debug("{} path exists - {}", (Object)propertyName, (Object)path);
                return path;
            }
            String absolutePath = Objects.requireNonNull(this.getClass().getClassLoader().getResource(path), path + " not found on the classpath").getPath();
            LOGGER.info("Transforming {} from {} to absolute path {}", new Object[]{propertyName, path, absolutePath});
            return absolutePath;
        }
        return path;
    }
}

