/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.interceptor;

import com.avioconsulting.mule.opentelemetry.api.config.MuleComponent;
import com.avioconsulting.mule.opentelemetry.internal.interceptor.ProcessorTracingInterceptor;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleCoreProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageProcessorTracingInterceptorFactory
implements ProcessorInterceptorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProcessorTracingInterceptorFactory.class);
    public static final String MULE_OTEL_INTERCEPTOR_PROCESSOR_ENABLE_PROPERTY_NAME = "mule.otel.interceptor.processor.enable";
    private final boolean interceptorEnabled = Boolean.parseBoolean(System.getProperty("mule.otel.interceptor.processor.enable", "true"));
    private final ProcessorTracingInterceptor processorTracingInterceptor;
    private final MuleNotificationProcessor muleNotificationProcessor;
    private final List<MuleComponent> interceptExclusions = new ArrayList<MuleComponent>();
    private final List<MuleComponent> interceptInclusions = new ArrayList<MuleComponent>();

    @Inject
    public MessageProcessorTracingInterceptorFactory(MuleNotificationProcessor muleNotificationProcessor, ConfigurationComponentLocator configurationComponentLocator) {
        this.processorTracingInterceptor = new ProcessorTracingInterceptor(muleNotificationProcessor, configurationComponentLocator);
        this.muleNotificationProcessor = muleNotificationProcessor;
        this.setupInterceptableComponents(muleNotificationProcessor);
    }

    private void setupInterceptableComponents(MuleNotificationProcessor muleNotificationProcessor) {
        String excludedNamespaces = "ee,mule,validations,aggregators,json,oauth,scripting,tracing,oauth2-provider,xml,wss,spring,java,avio-logger";
        Stream.of(excludedNamespaces.split(",")).forEach(ns -> this.interceptExclusions.add(new MuleComponent((String)ns, "*")));
        MuleCoreProcessorComponent.CORE_INTERCEPT_SCOPE_ROUTERS.forEach(c -> this.interceptInclusions.add(new MuleComponent("mule", (String)c)));
        if (muleNotificationProcessor.getTraceLevelConfiguration() != null) {
            if (muleNotificationProcessor.getTraceLevelConfiguration().getInterceptionDisabledComponents() != null) {
                this.interceptExclusions.addAll(muleNotificationProcessor.getTraceLevelConfiguration().getInterceptionDisabledComponents());
            }
            if (muleNotificationProcessor.getTraceLevelConfiguration().getInterceptionEnabledComponents() != null) {
                this.interceptInclusions.addAll(muleNotificationProcessor.getTraceLevelConfiguration().getInterceptionEnabledComponents());
            }
        }
    }

    public ProcessorInterceptor get() {
        return this.processorTracingInterceptor;
    }

    public List<MuleComponent> getInterceptExclusions() {
        return this.interceptExclusions;
    }

    public List<MuleComponent> getInterceptInclusions() {
        return this.interceptInclusions;
    }

    public boolean intercept(ComponentLocation location) {
        boolean intercept = false;
        if (this.interceptorEnabled && this.muleNotificationProcessor.hasConnection()) {
            ComponentIdentifier identifier = location.getComponentIdentifier().getIdentifier();
            boolean interceptConfigured = this.interceptInclusions.stream().anyMatch(mc -> mc.getNamespace().equalsIgnoreCase(identifier.getNamespace()) & (mc.getName().equalsIgnoreCase(identifier.getName()) || "*".equalsIgnoreCase(mc.getName()))) || this.interceptExclusions.stream().noneMatch(mc -> mc.getNamespace().equalsIgnoreCase(identifier.getNamespace()) & (mc.getName().equalsIgnoreCase(identifier.getName()) || "*".equalsIgnoreCase(mc.getName())));
            boolean bl = intercept = ComponentsUtil.isFirstProcessor(location) || interceptConfigured;
            if (intercept) {
                this.muleNotificationProcessor.addInterceptSpannedComponents(location.getLocation());
                if (interceptConfigured) {
                    this.muleNotificationProcessor.addMeteredComponentLocation(location.getLocation());
                }
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Will Intercept '{}'?: {}", (Object)location, (Object)intercept);
        }
        return intercept;
    }
}

