/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionStore;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.api.traces.TransactionContext;
import com.avioconsulting.mule.opentelemetry.internal.store.FlowSpan;
import com.avioconsulting.mule.opentelemetry.internal.store.ProcessorSpan;
import com.avioconsulting.mule.opentelemetry.internal.store.Transaction;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTransactionStore
implements TransactionStore {
    private static TransactionStore service;
    private final ConcurrentHashMap<String, Transaction> transactionMap = new ConcurrentHashMap();
    private static final Logger LOGGER;

    public static synchronized TransactionStore getInstance() {
        if (service == null) {
            service = new InMemoryTransactionStore();
        }
        return service;
    }

    @Override
    public void startTransaction(TraceComponent traceComponent, String rootFlowName, SpanBuilder rootFlowSpanBuilder) {
        String transactionId = traceComponent.getTransactionId();
        Transaction transaction = this.getTransaction(traceComponent.getTransactionId());
        if (transaction != null) {
            LOGGER.trace("Start transaction {} for flow '{}' - Adding to existing transaction", (Object)transactionId, (Object)rootFlowName);
            transaction.getRootFlowSpan().addProcessorSpan(null, traceComponent, rootFlowSpanBuilder);
        } else {
            Span span = rootFlowSpanBuilder.startSpan();
            LOGGER.trace("Start transaction {} for flow '{}': OT SpanId {}, TraceId {}", new Object[]{transactionId, rootFlowName, span.getSpanContext().getSpanId(), span.getSpanContext().getTraceId()});
            this.transactionMap.put(transactionId, new Transaction(traceComponent.getTransactionId(), span.getSpanContext().getTraceId(), rootFlowName, new FlowSpan(rootFlowName, span, transactionId).setTags(traceComponent.getTags()).setRootSpanName(traceComponent.getSpanName()), traceComponent.getStartTime()));
        }
    }

    @Override
    public void addTransactionTags(String transactionId, String tagPrefix, Map<String, String> tags) {
        AttributesBuilder builder = Attributes.builder();
        String format = "%s.%s";
        tags.forEach((k, v) -> builder.put(String.format(format, tagPrefix, k), v));
        Transaction transaction = this.getTransaction(transactionId);
        Span span = transaction.getRootFlowSpan().getSpan();
        if (span != null) {
            span.setAllAttributes(builder.build());
        }
    }

    private Transaction getTransaction(String transactionId) {
        return this.transactionMap.get(transactionId);
    }

    private TransactionContext getTransactionContext(Transaction transaction) {
        return transaction == null ? TransactionContext.current() : TransactionContext.of(transaction.getRootFlowSpan().getSpan());
    }

    @Override
    public TransactionContext getTransactionContext(String transactionId, String componentLocation) {
        Transaction transaction = this.getTransaction(transactionId);
        if (componentLocation == null) {
            return this.getTransactionContext(transaction);
        }
        ProcessorSpan processorSpan = null;
        if (transaction != null && (processorSpan = transaction.getRootFlowSpan().findSpan(componentLocation)) != null) {
            return TransactionContext.of(processorSpan.getSpan());
        }
        return this.getTransactionContext(transaction);
    }

    public String getTraceIdForTransaction(String transactionId) {
        return this.transactionMap.containsKey(transactionId) ? this.getTransaction(transactionId).getTraceId() : null;
    }

    @Override
    public TransactionMeta endTransaction(TraceComponent traceComponent, Consumer<Span> spanUpdater) {
        LOGGER.trace("End transaction {} for flow '{}'", (Object)traceComponent, (Object)traceComponent.getName());
        Consumer<Span> endSpan = span -> {
            if (spanUpdater != null) {
                spanUpdater.accept((Span)span);
            }
            span.end(traceComponent.getEndTime());
            LOGGER.trace("Ended transaction {} for flow '{}': OT SpanId {}, TraceId {}", new Object[]{traceComponent, traceComponent.getName(), span.getSpanContext().getSpanId(), span.getSpanContext().getTraceId()});
        };
        Transaction transaction = this.getTransaction(traceComponent.getTransactionId());
        if (transaction != null) {
            if (transaction.getRootFlowName().equals(traceComponent.getName())) {
                Transaction removed = this.transactionMap.remove(traceComponent.getTransactionId());
                endSpan.accept(removed.getRootFlowSpan().getSpan());
                removed.setEndTime(traceComponent.getEndTime());
            } else {
                ProcessorSpan processorSpan = transaction.getRootFlowSpan().findSpan(traceComponent.contextScopedPath(traceComponent.getName()));
                if (processorSpan != null) {
                    endSpan.accept(processorSpan.getSpan());
                    processorSpan.setEndTime(traceComponent.getEndTime());
                }
                return processorSpan;
            }
        }
        return transaction;
    }

    @Override
    public SpanMeta addProcessorSpan(String containerName, TraceComponent traceComponent, SpanBuilder spanBuilder) {
        Transaction transaction = this.getTransaction(traceComponent.getTransactionId());
        if (transaction == null) {
            return null;
        }
        LOGGER.trace("Adding Processor span to transaction {} for location '{}'", (Object)traceComponent.getTransactionId(), (Object)traceComponent.getLocation());
        SpanMeta span = transaction.getRootFlowSpan().addProcessorSpan(containerName, traceComponent, spanBuilder);
        LOGGER.trace("Adding Processor span to transaction {} for locator span '{}': OT SpanId {}, TraceId {}", new Object[]{traceComponent.getTransactionId(), traceComponent.getLocation(), span.getSpanId(), span.getTraceId()});
        return span;
    }

    @Override
    public SpanMeta endProcessorSpan(String transactionId, TraceComponent traceComponent, Consumer<Span> spanUpdater, Instant endTime) {
        LOGGER.trace("Ending Processor span of transaction {} for location '{}'", (Object)transactionId, (Object)traceComponent);
        Transaction transaction = this.getTransaction(transactionId);
        if (transaction == null) {
            return null;
        }
        return transaction.getRootFlowSpan().endProcessorSpan(traceComponent, spanUpdater, endTime);
    }

    static {
        LOGGER = LoggerFactory.getLogger(InMemoryTransactionStore.class);
    }
}

