/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api.config;

import com.avioconsulting.mule.opentelemetry.api.config.Attribute;
import com.avioconsulting.mule.opentelemetry.api.config.KeyValuePair;
import com.avioconsulting.mule.opentelemetry.api.config.OtelConfigMapProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@Alias(value="resource")
public class OpenTelemetryResource
implements OtelConfigMapProvider {
    @Parameter
    @Summary(value="Service name for this application.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String serviceName;
    @Parameter
    @Optional
    @NullSafe
    private List<Attribute> resourceAttributes;

    public String getServiceName() {
        return this.serviceName;
    }

    public List<Attribute> getResourceAttributes() {
        return this.resourceAttributes;
    }

    public OpenTelemetryResource() {
    }

    public OpenTelemetryResource(String serviceName, List<Attribute> resourceAttributes) {
        this.serviceName = serviceName;
        this.resourceAttributes = resourceAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenTelemetryResource that = (OpenTelemetryResource)o;
        return Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.resourceAttributes, that.resourceAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.serviceName, this.resourceAttributes);
    }

    @Override
    public Map<String, String> getConfigMap() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (this.getServiceName() != null) {
            configMap.put("otel.service.name", this.getServiceName());
        }
        configMap.put("otel.resource.attributes", KeyValuePair.commaSeparatedList(this.getResourceAttributes()));
        return Collections.unmodifiableMap(configMap);
    }
}

