/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal;

import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import java.util.Map;
import java.util.function.Supplier;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.ParameterResolver;
import org.mule.sdk.api.annotation.deprecated.Deprecated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryOperations {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenTelemetryOperations.class);

    @DisplayName(value="Get Trace Context")
    @Alias(value="get-trace-context")
    @Deprecated(message="Use Get Current Trace Context instead. When OTEL_TRACE_CONTEXT does not pre-exist, there is no way for users to get current transaction id.", since="2.3.0", toRemoveIn="3.0.0")
    public Map<String, String> getTraceContext(@Connection Supplier<OpenTelemetryConnection> openTelemetryConnection, @DisplayName(value="Trace Transaction Id") @Optional(defaultValue="#[vars.OTEL_TRACE_CONTEXT.TRACE_TRANSACTION_ID]") ParameterResolver<String> traceTransactionId, CorrelationInfo correlationInfo) {
        LOGGER.warn("get-trace-context has been deprecated. Use get-current-trace-context instead");
        return openTelemetryConnection.get().getTraceContext((String)traceTransactionId.resolve());
    }

    @DisplayName(value="Get Current Trace Context")
    @Alias(value="get-current-trace-context")
    @Summary(value="Gets the current trace context")
    public Map<String, String> getCurrentTraceContext(@Connection Supplier<OpenTelemetryConnection> openTelemetryConnection, CorrelationInfo correlationInfo) {
        String eventTransactionId = OpenTelemetryUtil.getEventTransactionId(correlationInfo.getEventId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Getting current context for event Id: {}, correlationId: {}, trace transactionId: {}", new Object[]{correlationInfo.getEventId(), correlationInfo.getCorrelationId(), eventTransactionId});
        }
        return openTelemetryConnection.get().getTraceContext(eventTransactionId);
    }

    @DisplayName(value="Add Custom Tags")
    @Deprecated(message="Use addTransactionTags instead. When OTEL_TRACE_CONTEXT does not pre-exist, there is no way for users to get current transaction id.", since="2.3.0", toRemoveIn="3.0.0")
    public void addCustomTags(@Connection Supplier<OpenTelemetryConnection> openTelemetryConnection, @DisplayName(value="Trace Transaction Id") @Optional(defaultValue="#[vars.OTEL_TRACE_CONTEXT.TRACE_TRANSACTION_ID]") ParameterResolver<String> traceTransactionId, Map<String, String> tags, CorrelationInfo correlationInfo) {
        LOGGER.warn("add-custom-tags has been deprecated. Use add-transaction-tags instead.");
        openTelemetryConnection.get().getTransactionStore().addTransactionTags((String)traceTransactionId.resolve(), "custom", tags);
    }

    @DisplayName(value="Add Transaction Tags")
    public void addTransactionTags(@Connection Supplier<OpenTelemetryConnection> openTelemetryConnection, Map<String, String> tags, CorrelationInfo correlationInfo) {
        String eventTransactionId = OpenTelemetryUtil.getEventTransactionId(correlationInfo.getEventId());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Add Transaction Tags for event Id: {}, correlationId: {}, trace transactionId: {}", new Object[]{correlationInfo.getEventId(), correlationInfo.getCorrelationId(), eventTransactionId});
        }
        openTelemetryConnection.get().getTransactionStore().addTransactionTags(eventTransactionId, "custom", tags);
    }
}

