/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk;

import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.resources.Resource;

public class MuleResource {
    private static Resource INSTANCE = MuleResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    public static void refresh() {
        INSTANCE = MuleResource.buildResource();
    }

    private static Resource buildResource() {
        AttributesBuilder builder = Attributes.builder();
        MuleResource.addAttribute("mule.home", builder, SemanticAttributes.MULE_HOME);
        MuleResource.addAttribute("csorganization.id", builder, SemanticAttributes.MULE_CSORGANIZATION_ID);
        MuleResource.addAttribute("csorganization.id", builder, SemanticAttributes.MULE_ORGANIZATION_ID);
        MuleResource.addAttribute("environment.id", builder, SemanticAttributes.MULE_ENVIRONMENT_ID);
        MuleResource.addAttribute("environment.type", builder, SemanticAttributes.MULE_ENVIRONMENT_TYPE);
        MuleResource.addAttribute("worker.id", builder, SemanticAttributes.MULE_WORKER_ID);
        MuleResource.addAttribute("domain", builder, SemanticAttributes.MULE_APP_DOMAIN);
        MuleResource.addAttribute("fullDomain", builder, SemanticAttributes.MULE_APP_FULL_DOMAIN);
        MuleResource.addAttribute("application.aws.region", builder, SemanticAttributes.MULE_ENVIRONMENT_AWS_REGION);
        Attributes build = builder.build();
        return Resource.create((Attributes)build);
    }

    private static void addAttribute(String sysProperty, AttributesBuilder builder, AttributeKey<String> attributeKey) {
        String value = System.getProperty(sysProperty);
        if (value != null) {
            builder.put(attributeKey, (Object)value);
        }
    }

    private MuleResource() {
    }
}

