/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.AbstractProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.ComponentWrapper;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.EnrichedServerNotification;

public class MuleCoreProcessorComponent
extends AbstractProcessorComponent {
    public static final List<String> CORE_INTERCEPT_SCOPE_ROUTERS = Arrays.asList("flow-ref", "choice", "first-successful", "until-successful", "scatter-gather", "round-robin", "foreach", "parallel-foreach", "try");
    private static List<String> CORE_PROCESSORS;

    @Override
    protected String getNamespace() {
        return "mule";
    }

    @Override
    protected List<String> getOperations() {
        return CORE_PROCESSORS;
    }

    @Override
    protected List<String> getSources() {
        return Collections.emptyList();
    }

    public MuleCoreProcessorComponent() {
        CORE_PROCESSORS = new ArrayList<String>(CORE_INTERCEPT_SCOPE_ROUTERS);
        CORE_PROCESSORS.add("async");
    }

    @Override
    public boolean canHandle(ComponentIdentifier componentIdentifier) {
        return super.canHandle(componentIdentifier);
    }

    @Override
    protected <A> Map<String, String> getAttributes(Component component, TypedValue<A> attributes) {
        HashMap<String, String> tags = new HashMap<String, String>();
        ComponentWrapper componentWrapper = new ComponentWrapper(component, this.configurationComponentLocator);
        if (ComponentsUtil.isFlowRef(component.getLocation())) {
            tags.put("mule.app.processor.flowRef.name", componentWrapper.getParameter("name"));
        }
        return tags;
    }

    @Override
    public TraceComponent getEndTraceComponent(EnrichedServerNotification notification) {
        TraceComponent endTraceComponent = super.getEndTraceComponent(notification);
        ComponentWrapper componentWrapper = new ComponentWrapper(notification.getComponent(), this.configurationComponentLocator);
        if (ComponentsUtil.isFlowRef(notification.getComponent().getLocation())) {
            endTraceComponent.getTags().put("mule.app.processor.flowRef.name", componentWrapper.getParameter("name"));
        }
        return endTraceComponent;
    }
}

