/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import com.avioconsulting.mule.opentelemetry.api.config.TraceLevelConfiguration;
import com.avioconsulting.mule.opentelemetry.api.processor.ProcessorComponent;
import com.avioconsulting.mule.opentelemetry.api.sdk.SemanticAttributes;
import com.avioconsulting.mule.opentelemetry.api.store.SpanMeta;
import com.avioconsulting.mule.opentelemetry.api.store.TransactionMeta;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.connection.OpenTelemetryConnection;
import com.avioconsulting.mule.opentelemetry.internal.processor.FlowProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.GenericProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.processor.service.ProcessorComponentService;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import io.opentelemetry.api.trace.SpanKind;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.AsyncMessageNotification;
import org.mule.runtime.api.notification.EnrichedServerNotification;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleNotificationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(MuleNotificationProcessor.class);
    public static final String MULE_OTEL_SPAN_PROCESSORS_ENABLE_PROPERTY_NAME = "mule.otel.span.processors.enable";
    private Supplier<OpenTelemetryConnection> connectionSupplier;
    private boolean spanAllProcessors;
    private TraceLevelConfiguration traceLevelConfiguration;
    private OpenTelemetryConnection openTelemetryConnection;
    ConfigurationComponentLocator configurationComponentLocator;
    private final List<String> interceptSpannedComponents = new ArrayList<String>();
    private final List<String> meteredComponentLocations = new ArrayList<String>();
    private ProcessorComponentService processorComponentService;
    private final ProcessorComponent flowProcessorComponent;
    private final ProcessorComponent genericProcessorComponent;

    @Inject
    public MuleNotificationProcessor(ConfigurationComponentLocator configurationComponentLocator) {
        this.configurationComponentLocator = configurationComponentLocator;
        this.flowProcessorComponent = new FlowProcessorComponent().withConfigurationComponentLocator(configurationComponentLocator);
        this.genericProcessorComponent = new GenericProcessorComponent().withConfigurationComponentLocator(configurationComponentLocator);
    }

    public void addInterceptSpannedComponents(String location) {
        this.interceptSpannedComponents.add(location);
    }

    public void addMeteredComponentLocation(String location) {
        if (this.openTelemetryConnection != null && !this.openTelemetryConnection.isTurnOffMetrics()) {
            this.openTelemetryConnection.getMetricsProviders().addMeteredComponent(location);
        }
    }

    public boolean hasConnection() {
        return this.openTelemetryConnection != null;
    }

    public OpenTelemetryConnection getOpenTelemetryConnection() {
        return this.openTelemetryConnection;
    }

    public Supplier<OpenTelemetryConnection> getConnectionSupplier() {
        return this.connectionSupplier;
    }

    public TraceLevelConfiguration getTraceLevelConfiguration() {
        return this.traceLevelConfiguration;
    }

    public void init(OpenTelemetryConnection connection, TraceLevelConfiguration traceLevelConfiguration) {
        this.openTelemetryConnection = connection;
        this.spanAllProcessors = Boolean.parseBoolean(System.getProperty(MULE_OTEL_SPAN_PROCESSORS_ENABLE_PROPERTY_NAME, Boolean.toString(traceLevelConfiguration.isSpanAllProcessors())));
        this.traceLevelConfiguration = traceLevelConfiguration;
        this.processorComponentService = ProcessorComponentService.getInstance();
    }

    public void handleProcessorStartEvent(MessageProcessorNotification notification) {
        String location = notification.getComponent().getLocation().getLocation();
        if (ComponentsUtil.isAsyncScope(notification.getComponent().getLocation().getComponentIdentifier())) {
            return;
        }
        if (this.interceptSpannedComponents.contains(location)) {
            logger.trace("Component {} will be processed by interceptor, skipping notification processing to create span", (Object)location);
            return;
        }
        this.processComponentStartSpan((EnrichedServerNotification)notification);
    }

    public void handleAsyncScheduledEvent(AsyncMessageNotification notification) {
        this.processComponentStartSpan((EnrichedServerNotification)notification);
    }

    private void processComponentStartSpan(EnrichedServerNotification notification) {
        try {
            ProcessorComponent processorComponent = this.getProcessorComponent(notification.getComponent().getIdentifier());
            if (processorComponent != null) {
                logger.trace("Handling '{}:{}' processor start event context id {} correlation id {} ", new Object[]{notification.getResourceIdentifier(), notification.getComponent().getIdentifier(), notification.getEvent().getContext().getId(), notification.getEvent().getCorrelationId()});
                TraceComponent traceComponent = processorComponent.getStartTraceComponent(notification).withStartTime(Instant.ofEpochMilli(notification.getTimestamp())).withEventContextId(notification.getEvent().getContext().getId()).withComponentLocation(notification.getComponent().getLocation());
                this.openTelemetryConnection.addProcessorSpan(traceComponent, ComponentsUtil.getLocationParent(notification.getComponent().getLocation().getLocation()));
                this.processFlowRef(traceComponent, notification.getEvent());
            }
        }
        catch (Exception ex) {
            logger.error("Error in handling processor start event", (Throwable)ex);
            throw ex;
        }
    }

    private void processFlowRef(TraceComponent traceComponent, Event event) {
        Optional<ComponentLocation> subFlowLocation;
        if (ComponentsUtil.isFlowRef(traceComponent.getComponentLocation()) && (subFlowLocation = ComponentsUtil.resolveFlowName(this.getOpenTelemetryConnection().getExpressionManager(), traceComponent, event.asBindingContext(), this.configurationComponentLocator)).isPresent()) {
            TraceComponent subflowTrace = ComponentsUtil.getTraceComponent(subFlowLocation.get(), traceComponent);
            this.getOpenTelemetryConnection().addProcessorSpan(subflowTrace, traceComponent.getComponentLocation().getLocation());
        }
    }

    ProcessorComponent getProcessorComponent(MessageProcessorNotification notification) {
        ComponentIdentifier identifier = notification.getComponent().getIdentifier();
        return this.getProcessorComponent(identifier);
    }

    public ProcessorComponent getProcessorComponent(ComponentIdentifier identifier) {
        boolean ignored = this.traceLevelConfiguration.getIgnoreMuleComponents().stream().anyMatch(mc -> mc.getNamespace().equalsIgnoreCase(identifier.getNamespace()) & (mc.getName().equalsIgnoreCase(identifier.getName()) || "*".equalsIgnoreCase(mc.getName())));
        if (this.spanAllProcessors && ignored) {
            return null;
        }
        ProcessorComponent processorComponent = this.processorComponentService.getProcessorComponentFor(identifier, this.configurationComponentLocator);
        if (processorComponent == null && this.spanAllProcessors) {
            processorComponent = this.genericProcessorComponent;
        }
        return processorComponent;
    }

    public void handleProcessorEndEvent(EnrichedServerNotification notification) {
        String location = notification.getComponent().getLocation().getLocation();
        try {
            ProcessorComponent processorComponent = this.getProcessorComponent(notification.getComponent().getIdentifier());
            if (processorComponent != null) {
                logger.trace("Handling '{}:{}' processor end event context id {} correlation id {} ", new Object[]{notification.getResourceIdentifier(), notification.getComponent().getIdentifier(), notification.getEvent().getContext().getId(), notification.getEvent().getCorrelationId()});
                TraceComponent traceComponent = processorComponent.getEndTraceComponent(notification).withEndTime(Instant.ofEpochMilli(notification.getTimestamp())).withEventContextId(notification.getEvent().getContext().getId());
                SpanMeta spanMeta = this.openTelemetryConnection.endProcessorSpan(traceComponent, notification.getEvent().getError().orElse(null));
                if (ComponentsUtil.isFlowRef(notification.getComponent().getLocation())) {
                    String targetFlowName = traceComponent.getTags().get("mule.app.processor.flowRef.name");
                    if (this.openTelemetryConnection.getExpressionManager().isExpression(targetFlowName)) {
                        logger.trace("Resolving expression '{}'", (Object)targetFlowName);
                        targetFlowName = this.openTelemetryConnection.getExpressionManager().evaluate(targetFlowName, notification.getEvent().asBindingContext()).getValue().toString();
                        logger.trace("Resolved to value '{}'", (Object)targetFlowName);
                    }
                    ComponentsUtil.findLocation(targetFlowName, this.configurationComponentLocator).filter(ComponentsUtil::isSubFlow).ifPresent(subFlowComp -> {
                        TraceComponent subflowTrace = TraceComponent.of(subFlowComp).withTransactionId(traceComponent.getTransactionId()).withSpanName(subFlowComp.getLocation()).withSpanKind(SpanKind.INTERNAL).withTags(Collections.singletonMap(SemanticAttributes.MULE_APP_SCOPE_SUBFLOW_NAME.getKey(), subFlowComp.getLocation())).withStatsCode(traceComponent.getStatusCode()).withEndTime(traceComponent.getEndTime()).withContext(traceComponent.getContext()).withEventContextId(notification.getEvent().getContext().getId());
                        SpanMeta subFlow = this.openTelemetryConnection.endProcessorSpan(subflowTrace, notification.getEvent().getError().orElse(null));
                        if (subFlow != null) {
                            this.openTelemetryConnection.getMetricsProviders().captureProcessorMetrics(notification.getComponent(), notification.getEvent().getError().orElse(null), location, spanMeta);
                        }
                    });
                }
                if (spanMeta != null) {
                    this.openTelemetryConnection.getMetricsProviders().captureProcessorMetrics(notification.getComponent(), notification.getEvent().getError().orElse(null), location, spanMeta);
                }
            }
        }
        catch (Exception ex) {
            logger.error("Error in handling processor end event", (Throwable)ex);
            throw ex;
        }
    }

    public void handleFlowStartEvent(PipelineMessageNotification notification) {
        try {
            logger.trace("Handling '{}' flow start event context id {} correlation id {} ", new Object[]{notification.getResourceIdentifier(), notification.getEvent().getContext().getId(), notification.getEvent().getCorrelationId()});
            TraceComponent traceComponent = this.flowProcessorComponent.getSourceStartTraceComponent((EnrichedServerNotification)notification, this.openTelemetryConnection).withStartTime(Instant.ofEpochMilli(notification.getTimestamp())).withEventContextId(notification.getEvent().getContext().getId());
            this.openTelemetryConnection.startTransaction(traceComponent);
        }
        catch (Exception ex) {
            logger.error("Error in handling " + notification.getResourceIdentifier() + " flow start event", (Throwable)ex);
            throw ex;
        }
    }

    public void handleFlowEndEvent(PipelineMessageNotification notification) {
        try {
            logger.trace("Handling '{}' flow end event context id {} correlation id {} ", new Object[]{notification.getResourceIdentifier(), notification.getEvent().getContext().getId(), notification.getEvent().getCorrelationId()});
            TraceComponent traceComponent = this.flowProcessorComponent.getSourceEndTraceComponent((EnrichedServerNotification)notification, this.openTelemetryConnection).withEndTime(Instant.ofEpochMilli(notification.getTimestamp())).withEventContextId(notification.getEvent().getContext().getId());
            TransactionMeta transactionMeta = this.openTelemetryConnection.endTransaction(traceComponent, notification.getException());
            if (transactionMeta == null) {
                TypedValue contextId = (TypedValue)notification.getEvent().getVariables().get("_OTEL_FLOW_CONTEXT_ID");
                if (contextId != null && contextId.getValue() != null) {
                    traceComponent = traceComponent.withEventContextId((String)contextId.getValue());
                }
                transactionMeta = this.openTelemetryConnection.endTransaction(traceComponent, notification.getException());
            }
            this.openTelemetryConnection.getMetricsProviders().captureFlowMetrics(Objects.requireNonNull(transactionMeta, "Transaction for " + traceComponent.contextScopedLocation() + " cannot be null"), notification.getResourceIdentifier(), notification.getException());
        }
        catch (Exception ex) {
            logger.error("Error in handling " + notification.getResourceIdentifier() + " flow end event", (Throwable)ex);
            throw ex;
        }
    }
}

