/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api.traces;

import java.util.Optional;

public interface ComponentEventContext {
    public String getEventContextId();

    public String getLocation();

    default public String getEventContextPrimaryId() {
        return this.getEventContextId().substring(0, this.getEventContextId().indexOf("_"));
    }

    default public int contextNestingLevel() {
        return this.getEventContextId().split("_").length;
    }

    default public String contextScopedPath(String path) {
        return this.getEventContextId() + "/" + path;
    }

    default public String contextCopedPath(String path, int prevLevel) {
        String eventContextId = this.getEventContextId();
        for (int i = 0; i < prevLevel; ++i) {
            eventContextId = eventContextId.substring(0, eventContextId.lastIndexOf("_"));
        }
        return eventContextId + "/" + path;
    }

    default public Optional<String> prevContextScopedPath(String path) {
        return Optional.ofNullable(this.getEventContextId().contains("_") ? this.getEventContextId().substring(0, this.getEventContextId().lastIndexOf("_")) + "/" + path : null);
    }

    default public String contextScopedLocation() {
        return ComponentEventContext.contextScopedLocationFor(this.getEventContextId(), this.getLocation());
    }

    public static String contextScopedLocationFor(String eventContextId, String location) {
        return eventContextId + "/" + location;
    }
}

