/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentWrapper {
    public static final String COMPONENT_NAMESPACE_KEY = "component:namespace";
    public static final String COMPONENT_NAME_KEY = "component:name";
    private final Component component;
    private final Map<String, String> parameters;
    private final ConfigurationComponentLocator configurationComponentLocator;
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentWrapper.class);

    public ComponentWrapper(Component component, ConfigurationComponentLocator configurationComponentLocator) {
        this.component = component;
        this.configurationComponentLocator = configurationComponentLocator;
        this.parameters = Collections.unmodifiableMap((Map)this.getComponentAnnotation("{config}componentParameters"));
    }

    public Component getComponent() {
        return this.component;
    }

    private <T> T getComponentAnnotation(String annotationName) {
        return (T)this.component.getAnnotation(QName.valueOf(annotationName));
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getName() {
        return this.parameters.get("name");
    }

    public String getParameter(String parameter) {
        return this.parameters.get(parameter);
    }

    public String getConfigRef() {
        return this.parameters.get("config-ref");
    }

    public String getDocName() {
        return this.parameters.get("doc:name");
    }

    public Map<String, String> getConfigConnectionParameters() {
        String componentConfigRef = this.getConfigRef();
        try {
            return this.configurationComponentLocator.find(Location.builder().globalName(componentConfigRef).addConnectionPart().build()).map(component1 -> new ComponentWrapper((Component)component1, this.configurationComponentLocator)).map(this::toExtendedParameters).orElse(Collections.emptyMap());
        }
        catch (Exception ex) {
            LOGGER.trace("Failed to extract connection parameters for {}. Ignoring this failure - {}", (Object)componentConfigRef, (Object)ex.getMessage());
            return Collections.emptyMap();
        }
    }

    public Map<String, String> getConfigParameters() {
        String componentConfigRef = this.getConfigRef();
        try {
            return this.configurationComponentLocator.find(Location.builder().globalName(componentConfigRef).build()).map(component1 -> new ComponentWrapper((Component)component1, this.configurationComponentLocator)).map(this::toExtendedParameters).orElse(Collections.emptyMap());
        }
        catch (Exception ex) {
            LOGGER.trace("Failed to extract connection parameters for {}. Ignoring this failure - {}", (Object)componentConfigRef, (Object)ex.getMessage());
            return Collections.emptyMap();
        }
    }

    private Map<String, String> toExtendedParameters(ComponentWrapper componentWrapper) {
        HashMap<String, String> map = new HashMap<String, String>(componentWrapper.getParameters());
        map.put(COMPONENT_NAMESPACE_KEY, componentWrapper.getComponent().getIdentifier().getNamespace());
        map.put(COMPONENT_NAME_KEY, componentWrapper.getComponent().getIdentifier().getName());
        return map;
    }
}

