/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api.traces;

import com.avioconsulting.mule.opentelemetry.api.util.EncodingUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.context.Context;
import java.util.Objects;

public class TransactionContext {
    private Context context = Context.current();
    private String spanId = SpanId.getInvalid();
    private String traceId = TraceId.getInvalid();
    private String spanIdLong = "0";
    private String traceIdLongLowPart = "0";

    public static TransactionContext of(Span span) {
        TransactionContext transactionContext = new TransactionContext().setContext(span.storeInContext(Context.current())).setSpanId(span.getSpanContext().getSpanId()).setTraceId(span.getSpanContext().getTraceId());
        if (SpanId.isValid((CharSequence)transactionContext.getSpanId())) {
            transactionContext.setSpanIdLong(EncodingUtil.longFromBase16Hex(transactionContext.getSpanId()));
        }
        if (TraceId.isValid((CharSequence)transactionContext.getTraceId())) {
            transactionContext.setTraceIdLongLowPart(EncodingUtil.traceIdLong(transactionContext.getTraceId())[1]);
        }
        return transactionContext;
    }

    public static TransactionContext current() {
        return new TransactionContext();
    }

    public Context getContext() {
        return this.context;
    }

    public TransactionContext setContext(Context context) {
        this.context = context;
        return this;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public TransactionContext setSpanId(String spanId) {
        this.spanId = spanId;
        return this;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public TransactionContext setTraceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    public String getSpanIdLong() {
        return this.spanIdLong;
    }

    public TransactionContext setSpanIdLong(String spanIdLong) {
        this.spanIdLong = spanIdLong;
        return this;
    }

    public String getTraceIdLongLowPart() {
        return this.traceIdLongLowPart;
    }

    public TransactionContext setTraceIdLongLowPart(String traceIdLongLowPart) {
        this.traceIdLongLowPart = traceIdLongLowPart;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionContext that = (TransactionContext)o;
        return Objects.equals(this.getContext(), that.getContext()) && Objects.equals(this.getSpanId(), that.getSpanId()) && Objects.equals(this.getTraceId(), that.getTraceId()) && Objects.equals(this.getSpanIdLong(), that.getSpanIdLong()) && Objects.equals(this.getTraceIdLongLowPart(), that.getTraceIdLongLowPart());
    }

    public int hashCode() {
        return Objects.hash(this.getContext(), this.getSpanId(), this.getTraceId(), this.getSpanIdLong(), this.getTraceIdLongLowPart());
    }
}

