/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.opentelemetry.sdk;

import com.avioconsulting.mule.opentelemetry.internal.util.OpenTelemetryUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.resources.ContainerResource;
import io.opentelemetry.instrumentation.resources.HostResource;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.incubating.ContainerIncubatingAttributes;
import io.opentelemetry.semconv.incubating.HostIncubatingAttributes;

public final class MuleAppHostResource {
    private static Resource INSTANCE = MuleAppHostResource.buildResource();

    public static Resource get() {
        return INSTANCE;
    }

    public static void refresh() {
        INSTANCE = MuleAppHostResource.buildResource();
    }

    private static Resource buildResource() {
        AttributesBuilder attributes = Attributes.builder();
        if (PropertiesUtil.isCloudHubV2()) {
            Resource containerResource = ContainerResource.get();
            OpenTelemetryUtil.addAttribute("NODE_NAME", attributes, (AttributeKey<String>)HostIncubatingAttributes.HOST_NAME);
            attributes.putAll(containerResource.getAttributes());
            OpenTelemetryUtil.addAttribute("HOSTNAME", attributes, (AttributeKey<String>)ContainerIncubatingAttributes.CONTAINER_NAME);
        } else if (PropertiesUtil.isCloudHubV1()) {
            OpenTelemetryUtil.addAttribute("environment.id", attributes, (AttributeKey<String>)HostIncubatingAttributes.HOST_NAME);
            String workerId = PropertiesUtil.getProperty("worker.id", "na");
            String container = String.format("%s-%s", PropertiesUtil.getProperty("domain"), workerId);
            if (PropertiesUtil.getProperty("worker.publicIP") != null) {
                attributes.put(HostIncubatingAttributes.HOST_IP, (Object[])new String[]{PropertiesUtil.getProperty("worker.publicIP")});
            }
            attributes.put(ContainerIncubatingAttributes.CONTAINER_NAME, (Object)container);
            attributes.put(ContainerIncubatingAttributes.CONTAINER_ID, (Object)container);
        } else {
            Resource hostResource = HostResource.get();
            attributes.putAll(hostResource.getAttributes());
        }
        return Resource.create((Attributes)attributes.build());
    }

    private MuleAppHostResource() {
    }
}

