/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.store;

import com.avioconsulting.mule.opentelemetry.api.store.TransactionMeta;
import com.avioconsulting.mule.opentelemetry.api.traces.TraceComponent;
import com.avioconsulting.mule.opentelemetry.internal.store.FlowSpan;
import io.opentelemetry.api.trace.Span;
import java.time.Instant;
import java.util.Map;
import java.util.function.Consumer;

public class Transaction
implements TransactionMeta {
    private final String transactionId;
    private final String rootFlowName;
    private final FlowSpan rootFlowSpan;
    private final String traceId;
    private final Instant startTime;
    private Instant endTime;

    public Transaction(String transactionId, String traceId, String rootFlowName, FlowSpan rootFlowSpan, Instant startTime) {
        this.transactionId = transactionId;
        this.rootFlowName = rootFlowName;
        this.rootFlowSpan = rootFlowSpan;
        this.traceId = traceId;
        this.startTime = startTime;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public String getRootFlowName() {
        return this.rootFlowName;
    }

    public FlowSpan getRootFlowSpan() {
        return this.rootFlowSpan;
    }

    @Override
    public Span getSpan() {
        return this.rootFlowSpan.getSpan();
    }

    @Override
    public String getTraceId() {
        return this.traceId;
    }

    @Override
    public Instant getStartTime() {
        return this.startTime;
    }

    @Override
    public Instant getEndTime() {
        return this.endTime;
    }

    private void setEndTime(Instant endTime) {
        this.endTime = endTime;
    }

    @Override
    public Map<String, String> getTags() {
        return this.getRootFlowSpan().getTags();
    }

    public boolean hasEnded() {
        return this.endTime != null && this.getRootFlowSpan().childFlowsEnded();
    }

    public void endRootFlow(TraceComponent traceComponent, Consumer<Span> endSpan) {
        endSpan.accept(this.getRootFlowSpan().getSpan());
        this.setEndTime(traceComponent.getEndTime());
    }
}

