/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.api.traces;

import com.avioconsulting.mule.opentelemetry.api.traces.ComponentEventContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.util.Map;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;

public class TraceComponent
implements ComponentEventContext {
    private Map<String, String> tags;
    private final String name;
    private String transactionId;
    private String spanName;
    private String location;
    private Context context;
    private SpanKind spanKind;
    private String errorMessage;
    private StatusCode statusCode;
    private Instant startTime = Instant.now();
    private Instant endTime;
    private String eventContextId;
    private ComponentLocation componentLocation;

    private TraceComponent(String name) {
        this.name = name;
    }

    public static TraceComponent of(String name) {
        return new TraceComponent(name);
    }

    public static TraceComponent of(String name, ComponentLocation location) {
        return TraceComponent.of(name).withLocation(location.getLocation()).withComponentLocation(location);
    }

    public static TraceComponent of(Component component) {
        return TraceComponent.of(component.getLocation());
    }

    public static TraceComponent of(ComponentLocation location) {
        return TraceComponent.of(location.getLocation(), location);
    }

    public SpanKind getSpanKind() {
        return this.spanKind;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public String getName() {
        return this.name;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getSpanName() {
        return this.spanName;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    @Override
    public String getEventContextId() {
        return this.eventContextId;
    }

    public ComponentLocation getComponentLocation() {
        return this.componentLocation;
    }

    public TraceComponent withTags(Map<String, String> val) {
        this.tags = val;
        return this;
    }

    public TraceComponent withTransactionId(String val) {
        this.transactionId = val;
        return this;
    }

    public TraceComponent withSpanName(String val) {
        this.spanName = val;
        return this;
    }

    public TraceComponent withLocation(String val) {
        this.location = val;
        return this;
    }

    public TraceComponent withContext(Context val) {
        this.context = val;
        return this;
    }

    public TraceComponent withSpanKind(SpanKind val) {
        this.spanKind = val;
        return this;
    }

    public TraceComponent withErrorMessage(String val) {
        this.errorMessage = val;
        return this;
    }

    public TraceComponent withStatsCode(StatusCode statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public TraceComponent withStartTime(Instant startTime) {
        this.startTime = startTime;
        return this;
    }

    public TraceComponent withEndTime(Instant endTime) {
        this.endTime = endTime;
        return this;
    }

    public TraceComponent withEventContextId(String eventContextId) {
        this.eventContextId = eventContextId;
        return this;
    }

    public TraceComponent withComponentLocation(ComponentLocation componentLocation) {
        this.componentLocation = componentLocation;
        return this;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String toString() {
        return "TraceComponent{tags=" + this.tags + ", name='" + this.name + '\'' + ", transactionId='" + this.transactionId + '\'' + ", spanName='" + this.spanName + '\'' + ", location='" + this.location + '\'' + ", context=" + this.context + ", spanKind=" + this.spanKind + ", errorMessage='" + this.errorMessage + '\'' + ", statusCode=" + this.statusCode + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", eventContextId='" + this.eventContextId + '\'' + ", componentLocation=" + this.componentLocation + '}';
    }
}

