/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.interceptor;

import com.avioconsulting.mule.opentelemetry.api.config.MuleComponent;
import com.avioconsulting.mule.opentelemetry.api.config.TraceLevelConfiguration;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleCoreProcessorComponent;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptorProcessorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterceptorProcessorConfig.class);
    public static final String MULE_OTEL_INTERCEPTOR_PROCESSOR_ENABLE_PROPERTY_NAME = "mule.otel.interceptor.processor.enable";
    private final boolean INTERCEPTOR_ENABLED_BY_SYS_PROPERTY = PropertiesUtil.getBoolean("mule.otel.interceptor.processor.enable", true);
    public static final String MULE_OTEL_INTERCEPTOR_FIRST_PROCESSOR_ONLY = "mule.otel.interceptor.first.processor.only";
    private final boolean NOT_FIRST_PROCESSOR_ONLY_MODE = !PropertiesUtil.getBoolean("mule.otel.interceptor.first.processor.only", false);
    private boolean turnOffTracing = false;
    private final List<String> interceptInclusions = new ArrayList<String>();
    private List<String> interceptDisabledByConfigComponents = new ArrayList<String>();
    private List<String> interceptEnabledByConfigComponents = new ArrayList<String>();

    public InterceptorProcessorConfig setTurnOffTracing(boolean turnOffTracing) {
        this.turnOffTracing = turnOffTracing;
        return this;
    }

    public InterceptorProcessorConfig() {
        this.setupInterceptComponents();
    }

    public void updateTraceConfiguration(TraceLevelConfiguration traceLevelConfiguration) {
        this.interceptDisabledByConfigComponents = traceLevelConfiguration.getInterceptionDisabledComponents().stream().map(MuleComponent::toString).collect(Collectors.toList());
        this.interceptEnabledByConfigComponents = traceLevelConfiguration.getInterceptionEnabledComponents().stream().map(MuleComponent::toString).collect(Collectors.toList());
    }

    private void setupInterceptComponents() {
        MuleCoreProcessorComponent.CORE_INTERCEPT_SCOPE_ROUTERS.forEach(c -> this.interceptInclusions.add("mule:" + c));
        try {
            InputStream interceptedComponentsFile = IOUtils.getResourceAsStream((String)"com/avioconsulting/mule/opentelemetry/internal/interceptor/intercept-components.txt", InterceptorProcessorConfig.class);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(interceptedComponentsFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("*")) continue;
                    String[] split = line.split(":");
                    LOGGER.trace("Attempting to add component to intercept: {}", (Object)line);
                    if (split.length == 2) {
                        this.interceptInclusions.add(line);
                        continue;
                    }
                    LOGGER.warn("Unable to parse intercept components entry: {}, skipping this line", (Object)line);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load interceptor components", e);
        }
    }

    public boolean interceptEnabled(ComponentLocation location) {
        if (!this.INTERCEPTOR_ENABLED_BY_SYS_PROPERTY) {
            LOGGER.trace("Interceptors are disabled by system property");
            return false;
        }
        if (this.turnOffTracing) {
            LOGGER.trace("Tracing has been turned off by global configuration");
            return false;
        }
        return ComponentsUtil.isFirstProcessor(location) || this.NOT_FIRST_PROCESSOR_ONLY_MODE && this.interceptEnabled(location.getComponentIdentifier().getIdentifier());
    }

    private boolean interceptEnabled(ComponentIdentifier componentIdentifier) {
        String identifier = componentIdentifier.getNamespace() + ":" + componentIdentifier.getName();
        String wildcardIdentifier = componentIdentifier.getNamespace() + ":*";
        if (this.interceptDisabledByConfigComponents.contains(wildcardIdentifier) && !this.interceptEnabledByConfigComponents.contains(identifier) || this.interceptDisabledByConfigComponents.contains(identifier)) {
            LOGGER.trace("Component {} is disabled by global configuration", (Object)identifier);
            return false;
        }
        if (this.interceptInclusions.contains(identifier)) {
            LOGGER.trace("Component {} is enabled by default configuration", (Object)identifier);
            return true;
        }
        if (this.interceptEnabledByConfigComponents.contains(wildcardIdentifier) || this.interceptEnabledByConfigComponents.contains(identifier)) {
            LOGGER.trace("Component {} is enabled by global configuration", (Object)identifier);
            return true;
        }
        LOGGER.trace("Component {} is not configured for interception, skipping interception", (Object)identifier);
        return false;
    }
}

