/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.interceptor;

import com.avioconsulting.mule.opentelemetry.internal.interceptor.ProcessorTracingInterceptor;
import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import com.avioconsulting.mule.opentelemetry.internal.util.ComponentsUtil;
import com.avioconsulting.mule.opentelemetry.internal.util.PropertiesUtil;
import javax.inject.Inject;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageProcessorTracingInterceptorFactory
implements ProcessorInterceptorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProcessorTracingInterceptorFactory.class);
    private final boolean interceptorEnabled = PropertiesUtil.getBoolean("mule.otel.interceptor.processor.enable", true);
    private final boolean NOT_FIRST_PROCESSOR_ONLY_MODE = !PropertiesUtil.getBoolean("mule.otel.interceptor.first.processor.only", false);
    private final ProcessorTracingInterceptor processorTracingInterceptor;

    @Inject
    public MessageProcessorTracingInterceptorFactory(MuleNotificationProcessor muleNotificationProcessor, ConfigurationComponentLocator configurationComponentLocator) {
        this.processorTracingInterceptor = new ProcessorTracingInterceptor(muleNotificationProcessor, configurationComponentLocator);
    }

    public ProcessorInterceptor get() {
        return this.processorTracingInterceptor;
    }

    public boolean intercept(ComponentLocation location) {
        boolean intercept = false;
        if (this.interceptorEnabled) {
            boolean bl = intercept = ComponentsUtil.isFirstProcessor(location) || this.NOT_FIRST_PROCESSOR_ONLY_MODE;
        }
        if (LOGGER.isTraceEnabled() && intercept) {
            LOGGER.trace("Will Intercept '{}::{}'", (Object)location.getRootContainerName(), (Object)location.getLocation());
        }
        return intercept;
    }
}

