/*
 * Decompiled with CFR 0.152.
 */
package com.avioconsulting.mule.opentelemetry.internal.notifications.listeners;

import com.avioconsulting.mule.opentelemetry.internal.processor.MuleNotificationProcessor;
import java.util.Collections;
import java.util.Map;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.metadata.TypedValue;
import org.slf4j.MDC;

public abstract class AbstractMuleNotificationListener {
    protected final MuleNotificationProcessor muleNotificationProcessor;

    public AbstractMuleNotificationListener(MuleNotificationProcessor muleNotificationProcessor) {
        this.muleNotificationProcessor = muleNotificationProcessor;
    }

    protected void replaceMDCEntry(Event event) {
        TypedValue contextMap = event.getVariables().getOrDefault("OTEL_TRACE_CONTEXT", TypedValue.of(Collections.emptyMap()));
        Map context = (Map)contextMap.getValue();
        this.replaceMDCEntry(context, "traceId");
        this.replaceMDCEntry(context, "traceIdLongLowPart");
        this.replaceMDCEntry(context, "spanId");
        this.replaceMDCEntry(context, "spanIdLong");
    }

    private void replaceMDCEntry(Map<String, String> contextMap, String key) {
        if (contextMap.containsKey(key)) {
            MDC.remove((String)key);
            MDC.put((String)key, (String)contextMap.get(key));
        }
    }
}

